package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{NextToken, RefreshedAt}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeInstancesHealthResponse(
    instanceHealthList: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.SingleInstanceHealth]
    ] = Optional.Absent,
    refreshedAt: Optional[RefreshedAt] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse = {
    import DescribeInstancesHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse
      .builder()
      .optionallyWith(
        instanceHealthList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceHealthList)
      .optionallyWith(
        refreshedAt.map(value => RefreshedAt.unwrap(value): Instant)
      )(_.refreshedAt)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse
      .wrap(buildAwsValue())
}
object DescribeInstancesHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse =
      zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse(
        instanceHealthList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        refreshedAt.map(value => value),
        nextToken.map(value => value)
      )
    def instanceHealthList: Optional[
      List[zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly]
    ]
    def refreshedAt: Optional[RefreshedAt]
    def nextToken: Optional[NextToken]
    def getInstanceHealthList: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceHealthList", instanceHealthList)
    def getRefreshedAt: ZIO[Any, AwsError, RefreshedAt] =
      AwsError.unwrapOptionField("refreshedAt", refreshedAt)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly {
    override val instanceHealthList: Optional[
      List[zio.aws.elasticbeanstalk.model.SingleInstanceHealth.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceHealthList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.SingleInstanceHealth.wrap(item)
        }.toList
      )
    override val refreshedAt: Optional[RefreshedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshedAt())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.RefreshedAt(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse
  ): zio.aws.elasticbeanstalk.model.DescribeInstancesHealthResponse.ReadOnly =
    new Wrapper(impl)
}
