package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePlatformVersionResponse(
    platformSummary: Optional[zio.aws.elasticbeanstalk.model.PlatformSummary] =
      Optional.Absent,
    platformBuilder: Optional[zio.aws.elasticbeanstalk.model.PlatformBuilder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse = {
    import CreatePlatformVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse
      .builder()
      .optionallyWith(platformSummary.map(value => value.buildAwsValue()))(
        _.platformSummary
      )
      .optionallyWith(platformBuilder.map(value => value.buildAwsValue()))(
        _.platformBuilder
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse
      .wrap(buildAwsValue())
}
object CreatePlatformVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse =
      zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse(
        platformSummary.map(value => value.asEditable),
        platformBuilder.map(value => value.asEditable)
      )
    def platformSummary
        : Optional[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly]
    def platformBuilder
        : Optional[zio.aws.elasticbeanstalk.model.PlatformBuilder.ReadOnly]
    def getPlatformSummary: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
    ] = AwsError.unwrapOptionField("platformSummary", platformSummary)
    def getPlatformBuilder: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.PlatformBuilder.ReadOnly
    ] = AwsError.unwrapOptionField("platformBuilder", platformBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse
  ) extends zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly {
    override val platformSummary
        : Optional[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformSummary())
        .map(value =>
          zio.aws.elasticbeanstalk.model.PlatformSummary.wrap(value)
        )
    override val platformBuilder
        : Optional[zio.aws.elasticbeanstalk.model.PlatformBuilder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformBuilder())
        .map(value =>
          zio.aws.elasticbeanstalk.model.PlatformBuilder.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse
  ): zio.aws.elasticbeanstalk.model.CreatePlatformVersionResponse.ReadOnly =
    new Wrapper(impl)
}
