package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  DeploymentTimestamp,
  NullableLong
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Deployment(
    versionLabel: Optional[String] = Optional.Absent,
    deploymentId: Optional[NullableLong] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    deploymentTime: Optional[DeploymentTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
      .builder()
      .optionallyWith(versionLabel.map(value => value: java.lang.String))(
        _.versionLabel
      )
      .optionallyWith(deploymentId.map(value => value: java.lang.Long))(
        _.deploymentId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        deploymentTime.map(value => DeploymentTimestamp.unwrap(value): Instant)
      )(_.deploymentTime)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.Deployment.ReadOnly =
    zio.aws.elasticbeanstalk.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.Deployment =
      zio.aws.elasticbeanstalk.model.Deployment(
        versionLabel.map(value => value),
        deploymentId.map(value => value),
        status.map(value => value),
        deploymentTime.map(value => value)
      )
    def versionLabel: Optional[String]
    def deploymentId: Optional[NullableLong]
    def status: Optional[String]
    def deploymentTime: Optional[DeploymentTimestamp]
    def getVersionLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getDeploymentId: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getDeploymentTime: ZIO[Any, AwsError, DeploymentTimestamp] =
      AwsError.unwrapOptionField("deploymentTime", deploymentTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
  ) extends zio.aws.elasticbeanstalk.model.Deployment.ReadOnly {
    override val versionLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionLabel())
      .map(value => value: String)
    override val deploymentId: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => value: NullableLong)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val deploymentTime: Optional[DeploymentTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentTime())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.DeploymentTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Deployment
  ): zio.aws.elasticbeanstalk.model.Deployment.ReadOnly = new Wrapper(impl)
}
