package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  VersionLabel,
  UpdateDate,
  Description,
  ApplicationArn,
  CreationDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ApplicationDescription(
    applicationArn: Optional[ApplicationArn] = Optional.Absent,
    applicationName: Optional[ApplicationName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    dateCreated: Optional[CreationDate] = Optional.Absent,
    dateUpdated: Optional[UpdateDate] = Optional.Absent,
    versions: Optional[Iterable[VersionLabel]] = Optional.Absent,
    configurationTemplates: Optional[Iterable[ConfigurationTemplateName]] =
      Optional.Absent,
    resourceLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription = {
    import ApplicationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
      .builder()
      .optionallyWith(
        applicationArn.map(value =>
          ApplicationArn.unwrap(value): java.lang.String
        )
      )(_.applicationArn)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            VersionLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        configurationTemplates.map(value =>
          value.map { item =>
            ConfigurationTemplateName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configurationTemplates)
      .optionallyWith(
        resourceLifecycleConfig.map(value => value.buildAwsValue())
      )(_.resourceLifecycleConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationDescription.wrap(buildAwsValue())
}
object ApplicationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ApplicationDescription =
      zio.aws.elasticbeanstalk.model.ApplicationDescription(
        applicationArn.map(value => value),
        applicationName.map(value => value),
        description.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        versions.map(value => value),
        configurationTemplates.map(value => value),
        resourceLifecycleConfig.map(value => value.asEditable)
      )
    def applicationArn: Optional[ApplicationArn]
    def applicationName: Optional[ApplicationName]
    def description: Optional[Description]
    def dateCreated: Optional[CreationDate]
    def dateUpdated: Optional[UpdateDate]
    def versions: Optional[List[VersionLabel]]
    def configurationTemplates: Optional[List[ConfigurationTemplateName]]
    def resourceLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ]
    def getApplicationArn: ZIO[Any, AwsError, ApplicationArn] =
      AwsError.unwrapOptionField("applicationArn", applicationArn)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getVersions: ZIO[Any, AwsError, List[VersionLabel]] =
      AwsError.unwrapOptionField("versions", versions)
    def getConfigurationTemplates
        : ZIO[Any, AwsError, List[ConfigurationTemplateName]] = AwsError
      .unwrapOptionField("configurationTemplates", configurationTemplates)
    def getResourceLifecycleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceLifecycleConfig",
      resourceLifecycleConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
  ) extends zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly {
    override val applicationArn: Optional[ApplicationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationArn())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationArn(value)
        )
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val dateCreated: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Optional[UpdateDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val versions: Optional[List[VersionLabel]] = zio.aws.core.internal
      .optionalFromNullable(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.VersionLabel(item)
        }.toList
      )
    override val configurationTemplates
        : Optional[List[ConfigurationTemplateName]] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(item)
        }.toList
      )
    override val resourceLifecycleConfig: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceLifecycleConfig())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
  ): zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly =
    new Wrapper(impl)
}
