package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationResponse(
    application: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
      .builder()
      .optionallyWith(application.map(value => value.buildAwsValue()))(
        _.application
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateApplicationResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.UpdateApplicationResponse =
      zio.aws.elasticbeanstalk.model
        .UpdateApplicationResponse(application.map(value => value.asEditable))
    def application: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly
    ]
    def getApplication: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly
    ] = AwsError.unwrapOptionField("application", application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
  ) extends zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly {
    override val application: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.application())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse
  ): zio.aws.elasticbeanstalk.model.UpdateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
