package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  PlatformVersion,
  PlatformName
}
import scala.jdk.CollectionConverters.*
final case class CreatePlatformVersionRequest(
    platformName: PlatformName,
    platformVersion: PlatformVersion,
    platformDefinitionBundle: zio.aws.elasticbeanstalk.model.S3Location,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    optionSettings: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticbeanstalk.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest = {
    import CreatePlatformVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest
      .builder()
      .platformName(PlatformName.unwrap(platformName): java.lang.String)
      .platformVersion(
        PlatformVersion.unwrap(platformVersion): java.lang.String
      )
      .platformDefinitionBundle(platformDefinitionBundle.buildAwsValue())
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreatePlatformVersionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreatePlatformVersionRequest
      .wrap(buildAwsValue())
}
object CreatePlatformVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreatePlatformVersionRequest =
      zio.aws.elasticbeanstalk.model.CreatePlatformVersionRequest(
        platformName,
        platformVersion,
        platformDefinitionBundle.asEditable,
        environmentName.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def platformName: PlatformName
    def platformVersion: PlatformVersion
    def platformDefinitionBundle
        : zio.aws.elasticbeanstalk.model.S3Location.ReadOnly
    def environmentName: Optional[EnvironmentName]
    def optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def getPlatformName: ZIO[Any, Nothing, PlatformName] =
      ZIO.succeed(platformName)
    def getPlatformVersion: ZIO[Any, Nothing, PlatformVersion] =
      ZIO.succeed(platformVersion)
    def getPlatformDefinitionBundle: ZIO[
      Any,
      Nothing,
      zio.aws.elasticbeanstalk.model.S3Location.ReadOnly
    ] = ZIO.succeed(platformDefinitionBundle)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest
  ) extends zio.aws.elasticbeanstalk.model.CreatePlatformVersionRequest.ReadOnly {
    override val platformName: PlatformName =
      zio.aws.elasticbeanstalk.model.primitives
        .PlatformName(impl.platformName())
    override val platformVersion: PlatformVersion =
      zio.aws.elasticbeanstalk.model.primitives
        .PlatformVersion(impl.platformVersion())
    override val platformDefinitionBundle
        : zio.aws.elasticbeanstalk.model.S3Location.ReadOnly =
      zio.aws.elasticbeanstalk.model.S3Location
        .wrap(impl.platformDefinitionBundle())
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest
  ): zio.aws.elasticbeanstalk.model.CreatePlatformVersionRequest.ReadOnly =
    new Wrapper(impl)
}
