package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationOptionName,
  ConfigurationOptionDefaultValue,
  ConfigurationOptionPossibleValue,
  OptionRestrictionMaxLength,
  UserDefinedOption,
  OptionNamespace,
  ConfigurationOptionSeverity,
  OptionRestrictionMinValue,
  OptionRestrictionMaxValue
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ConfigurationOptionDescription(
    namespace: Optional[OptionNamespace] = Optional.Absent,
    name: Optional[ConfigurationOptionName] = Optional.Absent,
    defaultValue: Optional[ConfigurationOptionDefaultValue] = Optional.Absent,
    changeSeverity: Optional[ConfigurationOptionSeverity] = Optional.Absent,
    userDefined: Optional[UserDefinedOption] = Optional.Absent,
    valueType: Optional[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType
    ] = Optional.Absent,
    valueOptions: Optional[Iterable[ConfigurationOptionPossibleValue]] =
      Optional.Absent,
    minValue: Optional[OptionRestrictionMinValue] = Optional.Absent,
    maxValue: Optional[OptionRestrictionMaxValue] = Optional.Absent,
    maxLength: Optional[OptionRestrictionMaxLength] = Optional.Absent,
    regex: Optional[zio.aws.elasticbeanstalk.model.OptionRestrictionRegex] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription = {
    import ConfigurationOptionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
      .builder()
      .optionallyWith(
        namespace.map(value => OptionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        name.map(value =>
          ConfigurationOptionName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        defaultValue.map(value =>
          ConfigurationOptionDefaultValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .optionallyWith(
        changeSeverity.map(value =>
          ConfigurationOptionSeverity.unwrap(value): java.lang.String
        )
      )(_.changeSeverity)
      .optionallyWith(
        userDefined.map(value =>
          UserDefinedOption.unwrap(value): java.lang.Boolean
        )
      )(_.userDefined)
      .optionallyWith(valueType.map(value => value.unwrap))(_.valueType)
      .optionallyWith(
        valueOptions.map(value =>
          value.map { item =>
            ConfigurationOptionPossibleValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.valueOptions)
      .optionallyWith(
        minValue.map(value => OptionRestrictionMinValue.unwrap(value): Integer)
      )(_.minValue)
      .optionallyWith(
        maxValue.map(value => OptionRestrictionMaxValue.unwrap(value): Integer)
      )(_.maxValue)
      .optionallyWith(
        maxLength.map(value =>
          OptionRestrictionMaxLength.unwrap(value): Integer
        )
      )(_.maxLength)
      .optionallyWith(regex.map(value => value.buildAwsValue()))(_.regex)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription
      .wrap(buildAwsValue())
}
object ConfigurationOptionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription =
      zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription(
        namespace.map(value => value),
        name.map(value => value),
        defaultValue.map(value => value),
        changeSeverity.map(value => value),
        userDefined.map(value => value),
        valueType.map(value => value),
        valueOptions.map(value => value),
        minValue.map(value => value),
        maxValue.map(value => value),
        maxLength.map(value => value),
        regex.map(value => value.asEditable)
      )
    def namespace: Optional[OptionNamespace]
    def name: Optional[ConfigurationOptionName]
    def defaultValue: Optional[ConfigurationOptionDefaultValue]
    def changeSeverity: Optional[ConfigurationOptionSeverity]
    def userDefined: Optional[UserDefinedOption]
    def valueType
        : Optional[zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType]
    def valueOptions: Optional[List[ConfigurationOptionPossibleValue]]
    def minValue: Optional[OptionRestrictionMinValue]
    def maxValue: Optional[OptionRestrictionMaxValue]
    def maxLength: Optional[OptionRestrictionMaxLength]
    def regex: Optional[
      zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly
    ]
    def getNamespace: ZIO[Any, AwsError, OptionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getName: ZIO[Any, AwsError, ConfigurationOptionName] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultValue: ZIO[Any, AwsError, ConfigurationOptionDefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getChangeSeverity: ZIO[Any, AwsError, ConfigurationOptionSeverity] =
      AwsError.unwrapOptionField("changeSeverity", changeSeverity)
    def getUserDefined: ZIO[Any, AwsError, UserDefinedOption] =
      AwsError.unwrapOptionField("userDefined", userDefined)
    def getValueType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType
    ] = AwsError.unwrapOptionField("valueType", valueType)
    def getValueOptions
        : ZIO[Any, AwsError, List[ConfigurationOptionPossibleValue]] =
      AwsError.unwrapOptionField("valueOptions", valueOptions)
    def getMinValue: ZIO[Any, AwsError, OptionRestrictionMinValue] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, OptionRestrictionMaxValue] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getMaxLength: ZIO[Any, AwsError, OptionRestrictionMaxLength] =
      AwsError.unwrapOptionField("maxLength", maxLength)
    def getRegex: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly
    ] = AwsError.unwrapOptionField("regex", regex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
  ) extends zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly {
    override val namespace: Optional[OptionNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OptionNamespace(value)
      )
    override val name: Optional[ConfigurationOptionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ConfigurationOptionName(value)
      )
    override val defaultValue: Optional[ConfigurationOptionDefaultValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationOptionDefaultValue(value)
        )
    override val changeSeverity: Optional[ConfigurationOptionSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeSeverity())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationOptionSeverity(value)
        )
    override val userDefined: Optional[UserDefinedOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDefined())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.UserDefinedOption(value)
        )
    override val valueType: Optional[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.valueType())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ConfigurationOptionValueType.wrap(value)
      )
    override val valueOptions
        : Optional[List[ConfigurationOptionPossibleValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives
              .ConfigurationOptionPossibleValue(item)
          }.toList
        )
    override val minValue: Optional[OptionRestrictionMinValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minValue())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .OptionRestrictionMinValue(value)
        )
    override val maxValue: Optional[OptionRestrictionMaxValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxValue())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .OptionRestrictionMaxValue(value)
        )
    override val maxLength: Optional[OptionRestrictionMaxLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxLength())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .OptionRestrictionMaxLength(value)
        )
    override val regex: Optional[
      zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.regex())
      .map(value =>
        zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription
  ): zio.aws.elasticbeanstalk.model.ConfigurationOptionDescription.ReadOnly =
    new Wrapper(impl)
}
