package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  NextToken,
  EnvironmentId,
  EnvironmentName
}
import scala.jdk.CollectionConverters.*
final case class DescribeInstancesHealthRequest(
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    attributeNames: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.InstancesHealthAttribute]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest = {
    import DescribeInstancesHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributeNamesWithStrings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeInstancesHealthRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeInstancesHealthRequest
      .wrap(buildAwsValue())
}
object DescribeInstancesHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeInstancesHealthRequest =
      zio.aws.elasticbeanstalk.model.DescribeInstancesHealthRequest(
        environmentName.map(value => value),
        environmentId.map(value => value),
        attributeNames.map(value => value),
        nextToken.map(value => value)
      )
    def environmentName: Optional[EnvironmentName]
    def environmentId: Optional[EnvironmentId]
    def attributeNames: Optional[
      List[zio.aws.elasticbeanstalk.model.InstancesHealthAttribute]
    ]
    def nextToken: Optional[NextToken]
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getAttributeNames: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.InstancesHealthAttribute
    ]] = AwsError.unwrapOptionField("attributeNames", attributeNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeInstancesHealthRequest.ReadOnly {
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val attributeNames: Optional[
      List[zio.aws.elasticbeanstalk.model.InstancesHealthAttribute]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.InstancesHealthAttribute.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest
  ): zio.aws.elasticbeanstalk.model.DescribeInstancesHealthRequest.ReadOnly =
    new Wrapper(impl)
}
