package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  EnvironmentName,
  SolutionStackName,
  PlatformArn,
  UpdateDate,
  Description,
  CreationDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationTemplateResponse(
    solutionStackName: Optional[SolutionStackName] = Optional.Absent,
    platformArn: Optional[PlatformArn] = Optional.Absent,
    applicationName: Optional[ApplicationName] = Optional.Absent,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    deploymentStatus: Optional[
      zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus
    ] = Optional.Absent,
    dateCreated: Optional[CreationDate] = Optional.Absent,
    dateUpdated: Optional[UpdateDate] = Optional.Absent,
    optionSettings: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse = {
    import UpdateConfigurationTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse
      .builder()
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse
      .wrap(buildAwsValue())
}
object UpdateConfigurationTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse =
      zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse(
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        applicationName.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        environmentName.map(value => value),
        deploymentStatus.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def solutionStackName: Optional[SolutionStackName]
    def platformArn: Optional[PlatformArn]
    def applicationName: Optional[ApplicationName]
    def templateName: Optional[ConfigurationTemplateName]
    def description: Optional[Description]
    def environmentName: Optional[EnvironmentName]
    def deploymentStatus
        : Optional[zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus]
    def dateCreated: Optional[CreationDate]
    def dateUpdated: Optional[UpdateDate]
    def optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getDeploymentStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus
    ] = AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse
  ) extends zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly {
    override val solutionStackName: Optional[SolutionStackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionStackName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
        )
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val deploymentStatus: Optional[
      zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentStatus())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ConfigurationDeploymentStatus.wrap(value)
      )
    override val dateCreated: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Optional[UpdateDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse
  ): zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
