package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  Description,
  ConfigurationTemplateName,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationTemplateRequest(
    applicationName: ApplicationName,
    templateName: ConfigurationTemplateName,
    description: Optional[Description] = Optional.Absent,
    optionSettings: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = Optional.Absent,
    optionsToRemove: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.OptionSpecification]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest = {
    import UpdateConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .templateName(
        ConfigurationTemplateName.unwrap(templateName): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        optionsToRemove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionsToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateRequest =
      zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateRequest(
        applicationName,
        templateName,
        description.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        optionsToRemove.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def templateName: ConfigurationTemplateName
    def description: Optional[Description]
    def optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def optionsToRemove: Optional[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTemplateName: ZIO[Any, Nothing, ConfigurationTemplateName] =
      ZIO.succeed(templateName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getOptionsToRemove: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("optionsToRemove", optionsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest
  ) extends zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val templateName: ConfigurationTemplateName =
      zio.aws.elasticbeanstalk.model.primitives
        .ConfigurationTemplateName(impl.templateName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
    override val optionsToRemove: Optional[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optionsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.OptionSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest
  ): zio.aws.elasticbeanstalk.model.UpdateConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
