package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  FileTypeExtension,
  SolutionStackName
}
import scala.jdk.CollectionConverters.*
final case class SolutionStackDescription(
    solutionStackName: Optional[SolutionStackName] = Optional.Absent,
    permittedFileTypes: Optional[Iterable[FileTypeExtension]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription = {
    import SolutionStackDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription
      .builder()
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        permittedFileTypes.map(value =>
          value.map { item =>
            FileTypeExtension.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permittedFileTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.SolutionStackDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.SolutionStackDescription
      .wrap(buildAwsValue())
}
object SolutionStackDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.SolutionStackDescription =
      zio.aws.elasticbeanstalk.model.SolutionStackDescription(
        solutionStackName.map(value => value),
        permittedFileTypes.map(value => value)
      )
    def solutionStackName: Optional[SolutionStackName]
    def permittedFileTypes: Optional[List[FileTypeExtension]]
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPermittedFileTypes: ZIO[Any, AwsError, List[FileTypeExtension]] =
      AwsError.unwrapOptionField("permittedFileTypes", permittedFileTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription
  ) extends zio.aws.elasticbeanstalk.model.SolutionStackDescription.ReadOnly {
    override val solutionStackName: Optional[SolutionStackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionStackName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
        )
    override val permittedFileTypes: Optional[List[FileTypeExtension]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permittedFileTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.FileTypeExtension(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription
  ): zio.aws.elasticbeanstalk.model.SolutionStackDescription.ReadOnly =
    new Wrapper(impl)
}
