package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEnvironmentManagedActionsRequest(
    environmentName: Optional[String] = Optional.Absent,
    environmentId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.elasticbeanstalk.model.ActionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest = {
    import DescribeEnvironmentManagedActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
      .builder()
      .optionallyWith(environmentName.map(value => value: java.lang.String))(
        _.environmentName
      )
      .optionallyWith(environmentId.map(value => value: java.lang.String))(
        _.environmentId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
      .wrap(buildAwsValue())
}
object DescribeEnvironmentManagedActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest(
        environmentName.map(value => value),
        environmentId.map(value => value),
        status.map(value => value)
      )
    def environmentName: Optional[String]
    def environmentId: Optional[String]
    def status: Optional[zio.aws.elasticbeanstalk.model.ActionStatus]
    def getEnvironmentName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getEnvironmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest.ReadOnly {
    override val environmentName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentName())
      .map(value => value: String)
    override val environmentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value => value: String)
    override val status: Optional[zio.aws.elasticbeanstalk.model.ActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.elasticbeanstalk.model.ActionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest.ReadOnly =
    new Wrapper(impl)
}
