package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ListPlatformVersionsResponse(
    platformSummaryList: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.PlatformSummary]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse = {
    import ListPlatformVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
      .builder()
      .optionallyWith(
        platformSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platformSummaryList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse
      .wrap(buildAwsValue())
}
object ListPlatformVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse =
      zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse(
        platformSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def platformSummaryList: Optional[
      List[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getPlatformSummaryList: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("platformSummaryList", platformSummaryList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
  ) extends zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly {
    override val platformSummaryList: Optional[
      List[zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.platformSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse
  ): zio.aws.elasticbeanstalk.model.ListPlatformVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
