package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.{
  OperationsRole,
  EnvironmentName
}
import scala.jdk.CollectionConverters.*
final case class AssociateEnvironmentOperationsRoleRequest(
    environmentName: EnvironmentName,
    operationsRole: OperationsRole
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest = {
    import AssociateEnvironmentOperationsRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest
      .builder()
      .environmentName(
        EnvironmentName.unwrap(environmentName): java.lang.String
      )
      .operationsRole(OperationsRole.unwrap(operationsRole): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest
      .wrap(buildAwsValue())
}
object AssociateEnvironmentOperationsRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest =
      zio.aws.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest(
        environmentName,
        operationsRole
      )
    def environmentName: EnvironmentName
    def operationsRole: OperationsRole
    def getEnvironmentName: ZIO[Any, Nothing, EnvironmentName] =
      ZIO.succeed(environmentName)
    def getOperationsRole: ZIO[Any, Nothing, OperationsRole] =
      ZIO.succeed(operationsRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest
  ) extends zio.aws.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest.ReadOnly {
    override val environmentName: EnvironmentName =
      zio.aws.elasticbeanstalk.model.primitives
        .EnvironmentName(impl.environmentName())
    override val operationsRole: OperationsRole =
      zio.aws.elasticbeanstalk.model.primitives
        .OperationsRole(impl.operationsRole())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest
  ): zio.aws.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest.ReadOnly =
    new Wrapper(impl)
}
