package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationOptionName,
  OptionNamespace,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class OptionSpecification(
    resourceName: Optional[ResourceName] = Optional.Absent,
    namespace: Optional[OptionNamespace] = Optional.Absent,
    optionName: Optional[ConfigurationOptionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification = {
    import OptionSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
      .builder()
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        namespace.map(value => OptionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        optionName.map(value =>
          ConfigurationOptionName.unwrap(value): java.lang.String
        )
      )(_.optionName)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly =
    zio.aws.elasticbeanstalk.model.OptionSpecification.wrap(buildAwsValue())
}
object OptionSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.OptionSpecification =
      zio.aws.elasticbeanstalk.model.OptionSpecification(
        resourceName.map(value => value),
        namespace.map(value => value),
        optionName.map(value => value)
      )
    def resourceName: Optional[ResourceName]
    def namespace: Optional[OptionNamespace]
    def optionName: Optional[ConfigurationOptionName]
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getNamespace: ZIO[Any, AwsError, OptionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getOptionName: ZIO[Any, AwsError, ConfigurationOptionName] =
      AwsError.unwrapOptionField("optionName", optionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
  ) extends zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly {
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ResourceName(value)
      )
    override val namespace: Optional[OptionNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OptionNamespace(value)
      )
    override val optionName: Optional[ConfigurationOptionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationOptionName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification
  ): zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly = new Wrapper(
    impl
  )
}
