package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  DNSCname,
  ApplicationName,
  EnvironmentArn,
  OperationsRole,
  EnvironmentName,
  AbortableOperationInProgress,
  SolutionStackName,
  VersionLabel,
  PlatformArn,
  UpdateDate,
  EnvironmentId,
  Description,
  EndpointURL,
  CreationDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TerminateEnvironmentResponse(
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    applicationName: Optional[ApplicationName] = Optional.Absent,
    versionLabel: Optional[VersionLabel] = Optional.Absent,
    solutionStackName: Optional[SolutionStackName] = Optional.Absent,
    platformArn: Optional[PlatformArn] = Optional.Absent,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    endpointURL: Optional[EndpointURL] = Optional.Absent,
    cname: Optional[DNSCname] = Optional.Absent,
    dateCreated: Optional[CreationDate] = Optional.Absent,
    dateUpdated: Optional[UpdateDate] = Optional.Absent,
    status: Optional[zio.aws.elasticbeanstalk.model.EnvironmentStatus] =
      Optional.Absent,
    abortableOperationInProgress: Optional[AbortableOperationInProgress] =
      Optional.Absent,
    health: Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealth] =
      Optional.Absent,
    healthStatus: Optional[
      zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus
    ] = Optional.Absent,
    resources: Optional[
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription
    ] = Optional.Absent,
    tier: Optional[zio.aws.elasticbeanstalk.model.EnvironmentTier] =
      Optional.Absent,
    environmentLinks: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.EnvironmentLink]
    ] = Optional.Absent,
    environmentArn: Optional[EnvironmentArn] = Optional.Absent,
    operationsRole: Optional[OperationsRole] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse = {
    import TerminateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        endpointURL.map(value => EndpointURL.unwrap(value): java.lang.String)
      )(_.endpointURL)
      .optionallyWith(
        cname.map(value => DNSCname.unwrap(value): java.lang.String)
      )(_.cname)
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        abortableOperationInProgress.map(value =>
          AbortableOperationInProgress.unwrap(value): java.lang.Boolean
        )
      )(_.abortableOperationInProgress)
      .optionallyWith(health.map(value => value.unwrap))(_.health)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(tier.map(value => value.buildAwsValue()))(_.tier)
      .optionallyWith(
        environmentLinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentLinks)
      .optionallyWith(
        environmentArn.map(value =>
          EnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        operationsRole.map(value =>
          OperationsRole.unwrap(value): java.lang.String
        )
      )(_.operationsRole)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse
      .wrap(buildAwsValue())
}
object TerminateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse =
      zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse(
        environmentName.map(value => value),
        environmentId.map(value => value),
        applicationName.map(value => value),
        versionLabel.map(value => value),
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        endpointURL.map(value => value),
        cname.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        status.map(value => value),
        abortableOperationInProgress.map(value => value),
        health.map(value => value),
        healthStatus.map(value => value),
        resources.map(value => value.asEditable),
        tier.map(value => value.asEditable),
        environmentLinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentArn.map(value => value),
        operationsRole.map(value => value)
      )
    def environmentName: Optional[EnvironmentName]
    def environmentId: Optional[EnvironmentId]
    def applicationName: Optional[ApplicationName]
    def versionLabel: Optional[VersionLabel]
    def solutionStackName: Optional[SolutionStackName]
    def platformArn: Optional[PlatformArn]
    def templateName: Optional[ConfigurationTemplateName]
    def description: Optional[Description]
    def endpointURL: Optional[EndpointURL]
    def cname: Optional[DNSCname]
    def dateCreated: Optional[CreationDate]
    def dateUpdated: Optional[UpdateDate]
    def status: Optional[zio.aws.elasticbeanstalk.model.EnvironmentStatus]
    def abortableOperationInProgress: Optional[AbortableOperationInProgress]
    def health: Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealth]
    def healthStatus
        : Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus]
    def resources: Optional[
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly
    ]
    def tier: Optional[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly]
    def environmentLinks: Optional[
      List[zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly]
    ]
    def environmentArn: Optional[EnvironmentArn]
    def operationsRole: Optional[OperationsRole]
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointURL: ZIO[Any, AwsError, EndpointURL] =
      AwsError.unwrapOptionField("endpointURL", endpointURL)
    def getCname: ZIO[Any, AwsError, DNSCname] =
      AwsError.unwrapOptionField("cname", cname)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAbortableOperationInProgress
        : ZIO[Any, AwsError, AbortableOperationInProgress] =
      AwsError.unwrapOptionField(
        "abortableOperationInProgress",
        abortableOperationInProgress
      )
    def getHealth
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EnvironmentHealth] =
      AwsError.unwrapOptionField("health", health)
    def getHealthStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus
    ] = AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getResources: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly
    ] = AwsError.unwrapOptionField("resources", resources)
    def getTier: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly
    ] = AwsError.unwrapOptionField("tier", tier)
    def getEnvironmentLinks: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentLinks", environmentLinks)
    def getEnvironmentArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getOperationsRole: ZIO[Any, AwsError, OperationsRole] =
      AwsError.unwrapOptionField("operationsRole", operationsRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
  ) extends zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly {
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val versionLabel: Optional[VersionLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val solutionStackName: Optional[SolutionStackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionStackName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
        )
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val endpointURL: Optional[EndpointURL] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointURL())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EndpointURL(value)
      )
    override val cname: Optional[DNSCname] = zio.aws.core.internal
      .optionalFromNullable(impl.cname())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.DNSCname(value))
    override val dateCreated: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Optional[UpdateDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val status
        : Optional[zio.aws.elasticbeanstalk.model.EnvironmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentStatus.wrap(value)
        )
    override val abortableOperationInProgress
        : Optional[AbortableOperationInProgress] = zio.aws.core.internal
      .optionalFromNullable(impl.abortableOperationInProgress())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .AbortableOperationInProgress(value)
      )
    override val health
        : Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.health())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentHealth.wrap(value)
        )
    override val healthStatus
        : Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus.wrap(value)
        )
    override val resources: Optional[
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription
          .wrap(value)
      )
    override val tier
        : Optional[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tier())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentTier.wrap(value)
        )
    override val environmentLinks: Optional[
      List[zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.EnvironmentLink.wrap(item)
        }.toList
      )
    override val environmentArn: Optional[EnvironmentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentArn())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentArn(value)
        )
    override val operationsRole: Optional[OperationsRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationsRole())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.OperationsRole(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
  ): zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
