package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  DeleteSourceBundle,
  VersionLabel,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationVersionRequest(
    applicationName: ApplicationName,
    versionLabel: VersionLabel,
    deleteSourceBundle: Optional[DeleteSourceBundle] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest = {
    import DeleteApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .versionLabel(VersionLabel.unwrap(versionLabel): java.lang.String)
      .optionallyWith(
        deleteSourceBundle.map(value =>
          DeleteSourceBundle.unwrap(value): java.lang.Boolean
        )
      )(_.deleteSourceBundle)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DeleteApplicationVersionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DeleteApplicationVersionRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DeleteApplicationVersionRequest =
      zio.aws.elasticbeanstalk.model.DeleteApplicationVersionRequest(
        applicationName,
        versionLabel,
        deleteSourceBundle.map(value => value)
      )
    def applicationName: ApplicationName
    def versionLabel: VersionLabel
    def deleteSourceBundle: Optional[DeleteSourceBundle]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getVersionLabel: ZIO[Any, Nothing, VersionLabel] =
      ZIO.succeed(versionLabel)
    def getDeleteSourceBundle: ZIO[Any, AwsError, DeleteSourceBundle] =
      AwsError.unwrapOptionField("deleteSourceBundle", deleteSourceBundle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest
  ) extends zio.aws.elasticbeanstalk.model.DeleteApplicationVersionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val versionLabel: VersionLabel =
      zio.aws.elasticbeanstalk.model.primitives
        .VersionLabel(impl.versionLabel())
    override val deleteSourceBundle: Optional[DeleteSourceBundle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteSourceBundle())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.DeleteSourceBundle(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest
  ): zio.aws.elasticbeanstalk.model.DeleteApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
