package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.BoxedInt
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ResourceQuota(maximum: Optional[BoxedInt] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota = {
    import ResourceQuota.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
      .builder()
      .optionallyWith(maximum.map(value => value: Integer))(_.maximum)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly =
    zio.aws.elasticbeanstalk.model.ResourceQuota.wrap(buildAwsValue())
}
object ResourceQuota {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ResourceQuota =
      zio.aws.elasticbeanstalk.model.ResourceQuota(maximum.map(value => value))
    def maximum: Optional[BoxedInt]
    def getMaximum: ZIO[Any, AwsError, BoxedInt] =
      AwsError.unwrapOptionField("maximum", maximum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
  ) extends zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly {
    override val maximum: Optional[BoxedInt] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => value: BoxedInt)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota
  ): zio.aws.elasticbeanstalk.model.ResourceQuota.ReadOnly = new Wrapper(impl)
}
