package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ApplicationVersionArn,
  ApplicationName,
  VersionLabel,
  UpdateDate,
  Description,
  CreationDate
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ApplicationVersionDescription(
    applicationVersionArn: Optional[ApplicationVersionArn] = Optional.Absent,
    applicationName: Optional[ApplicationName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    versionLabel: Optional[VersionLabel] = Optional.Absent,
    sourceBuildInformation: Optional[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation
    ] = Optional.Absent,
    buildArn: Optional[String] = Optional.Absent,
    sourceBundle: Optional[zio.aws.elasticbeanstalk.model.S3Location] =
      Optional.Absent,
    dateCreated: Optional[CreationDate] = Optional.Absent,
    dateUpdated: Optional[UpdateDate] = Optional.Absent,
    status: Optional[zio.aws.elasticbeanstalk.model.ApplicationVersionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription = {
    import ApplicationVersionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
      .builder()
      .optionallyWith(
        applicationVersionArn.map(value =>
          ApplicationVersionArn.unwrap(value): java.lang.String
        )
      )(_.applicationVersionArn)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        sourceBuildInformation.map(value => value.buildAwsValue())
      )(_.sourceBuildInformation)
      .optionallyWith(buildArn.map(value => value: java.lang.String))(
        _.buildArn
      )
      .optionallyWith(sourceBundle.map(value => value.buildAwsValue()))(
        _.sourceBundle
      )
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationVersionDescription
      .wrap(buildAwsValue())
}
object ApplicationVersionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplicationVersionDescription =
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription(
        applicationVersionArn.map(value => value),
        applicationName.map(value => value),
        description.map(value => value),
        versionLabel.map(value => value),
        sourceBuildInformation.map(value => value.asEditable),
        buildArn.map(value => value),
        sourceBundle.map(value => value.asEditable),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        status.map(value => value)
      )
    def applicationVersionArn: Optional[ApplicationVersionArn]
    def applicationName: Optional[ApplicationName]
    def description: Optional[Description]
    def versionLabel: Optional[VersionLabel]
    def sourceBuildInformation: Optional[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ]
    def buildArn: Optional[String]
    def sourceBundle
        : Optional[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly]
    def dateCreated: Optional[CreationDate]
    def dateUpdated: Optional[UpdateDate]
    def status
        : Optional[zio.aws.elasticbeanstalk.model.ApplicationVersionStatus]
    def getApplicationVersionArn: ZIO[Any, AwsError, ApplicationVersionArn] =
      AwsError.unwrapOptionField("applicationVersionArn", applicationVersionArn)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getSourceBuildInformation: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceBuildInformation",
      sourceBuildInformation
    )
    def getBuildArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("buildArn", buildArn)
    def getSourceBundle: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.S3Location.ReadOnly
    ] = AwsError.unwrapOptionField("sourceBundle", sourceBundle)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationVersionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
  ) extends zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly {
    override val applicationVersionArn: Optional[ApplicationVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationVersionArn())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationVersionArn(value)
        )
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val versionLabel: Optional[VersionLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val sourceBuildInformation: Optional[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBuildInformation())
      .map(value =>
        zio.aws.elasticbeanstalk.model.SourceBuildInformation.wrap(value)
      )
    override val buildArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.buildArn())
      .map(value => value: String)
    override val sourceBundle
        : Optional[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceBundle())
        .map(value => zio.aws.elasticbeanstalk.model.S3Location.wrap(value))
    override val dateCreated: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Optional[UpdateDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val status
        : Optional[zio.aws.elasticbeanstalk.model.ApplicationVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ApplicationVersionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription
  ): zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly =
    new Wrapper(impl)
}
