package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class Instance(id: Optional[ResourceId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.Instance
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.Instance.ReadOnly =
    zio.aws.elasticbeanstalk.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.Instance =
      zio.aws.elasticbeanstalk.model.Instance(id.map(value => value))
    def id: Optional[ResourceId]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Instance
  ) extends zio.aws.elasticbeanstalk.model.Instance.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.Instance
  ): zio.aws.elasticbeanstalk.model.Instance.ReadOnly = new Wrapper(impl)
}
