package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  Token,
  MaxRecords,
  VersionLabel,
  ApplicationName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationVersionsRequest(
    applicationName: Optional[ApplicationName] = Optional.Absent,
    versionLabels: Optional[Iterable[VersionLabel]] = Optional.Absent,
    maxRecords: Optional[MaxRecords] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest = {
    import DescribeApplicationVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabels.map(value =>
          value.map { item =>
            VersionLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionLabels)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest =
      zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest(
        applicationName.map(value => value),
        versionLabels.map(value => value),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: Optional[ApplicationName]
    def versionLabels: Optional[List[VersionLabel]]
    def maxRecords: Optional[MaxRecords]
    def nextToken: Optional[Token]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabels: ZIO[Any, AwsError, List[VersionLabel]] =
      AwsError.unwrapOptionField("versionLabels", versionLabels)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest.ReadOnly {
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val versionLabels: Optional[List[VersionLabel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.VersionLabel(item)
          }.toList
        )
    override val maxRecords: Optional[MaxRecords] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.MaxRecords(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
