package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{RegexLabel, RegexPattern}
import scala.jdk.CollectionConverters.*
final case class OptionRestrictionRegex(
    pattern: Optional[RegexPattern] = Optional.Absent,
    label: Optional[RegexLabel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.OptionRestrictionRegex = {
    import OptionRestrictionRegex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.OptionRestrictionRegex
      .builder()
      .optionallyWith(
        pattern.map(value => RegexPattern.unwrap(value): java.lang.String)
      )(_.pattern)
      .optionallyWith(
        label.map(value => RegexLabel.unwrap(value): java.lang.String)
      )(_.label)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly =
    zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.wrap(buildAwsValue())
}
object OptionRestrictionRegex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.OptionRestrictionRegex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.OptionRestrictionRegex =
      zio.aws.elasticbeanstalk.model.OptionRestrictionRegex(
        pattern.map(value => value),
        label.map(value => value)
      )
    def pattern: Optional[RegexPattern]
    def label: Optional[RegexLabel]
    def getPattern: ZIO[Any, AwsError, RegexPattern] =
      AwsError.unwrapOptionField("pattern", pattern)
    def getLabel: ZIO[Any, AwsError, RegexLabel] =
      AwsError.unwrapOptionField("label", label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.OptionRestrictionRegex
  ) extends zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly {
    override val pattern: Optional[RegexPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.pattern())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.RegexPattern(value)
      )
    override val label: Optional[RegexLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.RegexLabel(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.OptionRestrictionRegex
  ): zio.aws.elasticbeanstalk.model.OptionRestrictionRegex.ReadOnly =
    new Wrapper(impl)
}
