package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters.*
final case class RequestEnvironmentInfoRequest(
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    infoType: zio.aws.elasticbeanstalk.model.EnvironmentInfoType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest = {
    import RequestEnvironmentInfoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .infoType(infoType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.RequestEnvironmentInfoRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.RequestEnvironmentInfoRequest
      .wrap(buildAwsValue())
}
object RequestEnvironmentInfoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.RequestEnvironmentInfoRequest =
      zio.aws.elasticbeanstalk.model.RequestEnvironmentInfoRequest(
        environmentId.map(value => value),
        environmentName.map(value => value),
        infoType
      )
    def environmentId: Optional[EnvironmentId]
    def environmentName: Optional[EnvironmentName]
    def infoType: zio.aws.elasticbeanstalk.model.EnvironmentInfoType
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getInfoType: ZIO[
      Any,
      Nothing,
      zio.aws.elasticbeanstalk.model.EnvironmentInfoType
    ] = ZIO.succeed(infoType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest
  ) extends zio.aws.elasticbeanstalk.model.RequestEnvironmentInfoRequest.ReadOnly {
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val infoType: zio.aws.elasticbeanstalk.model.EnvironmentInfoType =
      zio.aws.elasticbeanstalk.model.EnvironmentInfoType.wrap(impl.infoType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest
  ): zio.aws.elasticbeanstalk.model.RequestEnvironmentInfoRequest.ReadOnly =
    new Wrapper(impl)
}
