package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  ApplicationVersionProccess,
  ApplicationName,
  AutoCreateApplication,
  VersionLabel,
  Description
}
import scala.jdk.CollectionConverters.*
final case class CreateApplicationVersionRequest(
    applicationName: ApplicationName,
    versionLabel: VersionLabel,
    description: Optional[Description] = Optional.Absent,
    sourceBuildInformation: Optional[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation
    ] = Optional.Absent,
    sourceBundle: Optional[zio.aws.elasticbeanstalk.model.S3Location] =
      Optional.Absent,
    buildConfiguration: Optional[
      zio.aws.elasticbeanstalk.model.BuildConfiguration
    ] = Optional.Absent,
    autoCreateApplication: Optional[AutoCreateApplication] = Optional.Absent,
    process: Optional[ApplicationVersionProccess] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticbeanstalk.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest = {
    import CreateApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .versionLabel(VersionLabel.unwrap(versionLabel): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        sourceBuildInformation.map(value => value.buildAwsValue())
      )(_.sourceBuildInformation)
      .optionallyWith(sourceBundle.map(value => value.buildAwsValue()))(
        _.sourceBundle
      )
      .optionallyWith(buildConfiguration.map(value => value.buildAwsValue()))(
        _.buildConfiguration
      )
      .optionallyWith(
        autoCreateApplication.map(value =>
          AutoCreateApplication.unwrap(value): java.lang.Boolean
        )
      )(_.autoCreateApplication)
      .optionallyWith(
        process.map(value =>
          ApplicationVersionProccess.unwrap(value): java.lang.Boolean
        )
      )(_.process)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest
      .wrap(buildAwsValue())
}
object CreateApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest =
      zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest(
        applicationName,
        versionLabel,
        description.map(value => value),
        sourceBuildInformation.map(value => value.asEditable),
        sourceBundle.map(value => value.asEditable),
        buildConfiguration.map(value => value.asEditable),
        autoCreateApplication.map(value => value),
        process.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def versionLabel: VersionLabel
    def description: Optional[Description]
    def sourceBuildInformation: Optional[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ]
    def sourceBundle
        : Optional[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly]
    def buildConfiguration
        : Optional[zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly]
    def autoCreateApplication: Optional[AutoCreateApplication]
    def process: Optional[ApplicationVersionProccess]
    def tags: Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getVersionLabel: ZIO[Any, Nothing, VersionLabel] =
      ZIO.succeed(versionLabel)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSourceBuildInformation: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceBuildInformation",
      sourceBuildInformation
    )
    def getSourceBundle: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.S3Location.ReadOnly
    ] = AwsError.unwrapOptionField("sourceBundle", sourceBundle)
    def getBuildConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("buildConfiguration", buildConfiguration)
    def getAutoCreateApplication: ZIO[Any, AwsError, AutoCreateApplication] =
      AwsError.unwrapOptionField("autoCreateApplication", autoCreateApplication)
    def getProcess: ZIO[Any, AwsError, ApplicationVersionProccess] =
      AwsError.unwrapOptionField("process", process)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
  ) extends zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val versionLabel: VersionLabel =
      zio.aws.elasticbeanstalk.model.primitives
        .VersionLabel(impl.versionLabel())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val sourceBuildInformation: Optional[
      zio.aws.elasticbeanstalk.model.SourceBuildInformation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBuildInformation())
      .map(value =>
        zio.aws.elasticbeanstalk.model.SourceBuildInformation.wrap(value)
      )
    override val sourceBundle
        : Optional[zio.aws.elasticbeanstalk.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceBundle())
        .map(value => zio.aws.elasticbeanstalk.model.S3Location.wrap(value))
    override val buildConfiguration
        : Optional[zio.aws.elasticbeanstalk.model.BuildConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildConfiguration())
        .map(value =>
          zio.aws.elasticbeanstalk.model.BuildConfiguration.wrap(value)
        )
    override val autoCreateApplication: Optional[AutoCreateApplication] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoCreateApplication())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.AutoCreateApplication(value)
        )
    override val process: Optional[ApplicationVersionProccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.process())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ApplicationVersionProccess(value)
        )
    override val tags
        : Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest
  ): zio.aws.elasticbeanstalk.model.CreateApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
