package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  ForceTerminate,
  TerminateEnvironmentResources,
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters.*
final case class TerminateEnvironmentRequest(
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    terminateResources: Optional[TerminateEnvironmentResources] =
      Optional.Absent,
    forceTerminate: Optional[ForceTerminate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest = {
    import TerminateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        terminateResources.map(value =>
          TerminateEnvironmentResources.unwrap(value): java.lang.Boolean
        )
      )(_.terminateResources)
      .optionallyWith(
        forceTerminate.map(value =>
          ForceTerminate.unwrap(value): java.lang.Boolean
        )
      )(_.forceTerminate)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest
      .wrap(buildAwsValue())
}
object TerminateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest =
      zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest(
        environmentId.map(value => value),
        environmentName.map(value => value),
        terminateResources.map(value => value),
        forceTerminate.map(value => value)
      )
    def environmentId: Optional[EnvironmentId]
    def environmentName: Optional[EnvironmentName]
    def terminateResources: Optional[TerminateEnvironmentResources]
    def forceTerminate: Optional[ForceTerminate]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getTerminateResources
        : ZIO[Any, AwsError, TerminateEnvironmentResources] =
      AwsError.unwrapOptionField("terminateResources", terminateResources)
    def getForceTerminate: ZIO[Any, AwsError, ForceTerminate] =
      AwsError.unwrapOptionField("forceTerminate", forceTerminate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
  ) extends zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest.ReadOnly {
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val terminateResources: Optional[TerminateEnvironmentResources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminateResources())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .TerminateEnvironmentResources(value)
        )
    override val forceTerminate: Optional[ForceTerminate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceTerminate())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ForceTerminate(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest
  ): zio.aws.elasticbeanstalk.model.TerminateEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
