package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ComposeEnvironmentsResponse(
    environments: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.EnvironmentDescription]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse = {
    import ComposeEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse
      .builder()
      .optionallyWith(
        environments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environments)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse
      .wrap(buildAwsValue())
}
object ComposeEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse =
      zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse(
        environments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def environments: Optional[
      List[zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getEnvironments: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("environments", environments)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse
  ) extends zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly {
    override val environments: Optional[
      List[zio.aws.elasticbeanstalk.model.EnvironmentDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.EnvironmentDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse
  ): zio.aws.elasticbeanstalk.model.ComposeEnvironmentsResponse.ReadOnly =
    new Wrapper(impl)
}
