package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters.*
final case class DescribeEnvironmentResourcesRequest(
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest = {
    import DescribeEnvironmentResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest
      .wrap(buildAwsValue())
}
object DescribeEnvironmentResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest(
        environmentId.map(value => value),
        environmentName.map(value => value)
      )
    def environmentId: Optional[EnvironmentId]
    def environmentName: Optional[EnvironmentName]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest.ReadOnly {
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
