package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters.*
final case class RebuildEnvironmentRequest(
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest = {
    import RebuildEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.RebuildEnvironmentRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.RebuildEnvironmentRequest
      .wrap(buildAwsValue())
}
object RebuildEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.RebuildEnvironmentRequest =
      zio.aws.elasticbeanstalk.model.RebuildEnvironmentRequest(
        environmentId.map(value => value),
        environmentName.map(value => value)
      )
    def environmentId: Optional[EnvironmentId]
    def environmentName: Optional[EnvironmentName]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest
  ) extends zio.aws.elasticbeanstalk.model.RebuildEnvironmentRequest.ReadOnly {
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest
  ): zio.aws.elasticbeanstalk.model.RebuildEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
