package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.SourceType
  ): zio.aws.elasticbeanstalk.model.SourceType = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.SourceType.GIT =>
      val r = Git
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.SourceType.ZIP =>
      val r = Zip
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.SourceType =
      software.amazon.awssdk.services.elasticbeanstalk.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object Git extends zio.aws.elasticbeanstalk.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.SourceType =
      software.amazon.awssdk.services.elasticbeanstalk.model.SourceType.GIT
  }
  case object Zip extends zio.aws.elasticbeanstalk.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.SourceType =
      software.amazon.awssdk.services.elasticbeanstalk.model.SourceType.ZIP
  }
}
