package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  EnvironmentName,
  EnvironmentId
}
import scala.jdk.CollectionConverters.*
final case class AbortEnvironmentUpdateRequest(
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest = {
    import AbortEnvironmentUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
      .builder()
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
      .wrap(buildAwsValue())
}
object AbortEnvironmentUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest =
      zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest(
        environmentId.map(value => value),
        environmentName.map(value => value)
      )
    def environmentId: Optional[EnvironmentId]
    def environmentName: Optional[EnvironmentName]
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
  ) extends zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest.ReadOnly {
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
  ): zio.aws.elasticbeanstalk.model.AbortEnvironmentUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
