package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.NullableInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class InstanceHealthSummary(
    noData: Optional[NullableInteger] = Optional.Absent,
    unknown: Optional[NullableInteger] = Optional.Absent,
    pending: Optional[NullableInteger] = Optional.Absent,
    ok: Optional[NullableInteger] = Optional.Absent,
    info: Optional[NullableInteger] = Optional.Absent,
    warning: Optional[NullableInteger] = Optional.Absent,
    degraded: Optional[NullableInteger] = Optional.Absent,
    severe: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary = {
    import InstanceHealthSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
      .builder()
      .optionallyWith(noData.map(value => value: Integer))(_.noData)
      .optionallyWith(unknown.map(value => value: Integer))(_.unknown)
      .optionallyWith(pending.map(value => value: Integer))(_.pending)
      .optionallyWith(ok.map(value => value: Integer))(_.ok)
      .optionallyWith(info.map(value => value: Integer))(_.info)
      .optionallyWith(warning.map(value => value: Integer))(_.warning)
      .optionallyWith(degraded.map(value => value: Integer))(_.degraded)
      .optionallyWith(severe.map(value => value: Integer))(_.severe)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly =
    zio.aws.elasticbeanstalk.model.InstanceHealthSummary.wrap(buildAwsValue())
}
object InstanceHealthSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.InstanceHealthSummary =
      zio.aws.elasticbeanstalk.model.InstanceHealthSummary(
        noData.map(value => value),
        unknown.map(value => value),
        pending.map(value => value),
        ok.map(value => value),
        info.map(value => value),
        warning.map(value => value),
        degraded.map(value => value),
        severe.map(value => value)
      )
    def noData: Optional[NullableInteger]
    def unknown: Optional[NullableInteger]
    def pending: Optional[NullableInteger]
    def ok: Optional[NullableInteger]
    def info: Optional[NullableInteger]
    def warning: Optional[NullableInteger]
    def degraded: Optional[NullableInteger]
    def severe: Optional[NullableInteger]
    def getNoData: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("noData", noData)
    def getUnknown: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("unknown", unknown)
    def getPending: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("pending", pending)
    def getOk: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("ok", ok)
    def getInfo: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("info", info)
    def getWarning: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("warning", warning)
    def getDegraded: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("degraded", degraded)
    def getSevere: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("severe", severe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
  ) extends zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly {
    override val noData: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.noData())
      .map(value => value: NullableInteger)
    override val unknown: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.unknown())
      .map(value => value: NullableInteger)
    override val pending: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.pending())
      .map(value => value: NullableInteger)
    override val ok: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.ok())
      .map(value => value: NullableInteger)
    override val info: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.info())
      .map(value => value: NullableInteger)
    override val warning: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.warning())
      .map(value => value: NullableInteger)
    override val degraded: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.degraded())
      .map(value => value: NullableInteger)
    override val severe: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.severe())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthSummary
  ): zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly =
    new Wrapper(impl)
}
