package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplyEnvironmentManagedActionResponse(
    actionId: Optional[String] = Optional.Absent,
    actionDescription: Optional[String] = Optional.Absent,
    actionType: Optional[zio.aws.elasticbeanstalk.model.ActionType] =
      Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse = {
    import ApplyEnvironmentManagedActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
      .builder()
      .optionallyWith(actionId.map(value => value: java.lang.String))(
        _.actionId
      )
      .optionallyWith(actionDescription.map(value => value: java.lang.String))(
        _.actionDescription
      )
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
      .wrap(buildAwsValue())
}
object ApplyEnvironmentManagedActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse =
      zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse(
        actionId.map(value => value),
        actionDescription.map(value => value),
        actionType.map(value => value),
        status.map(value => value)
      )
    def actionId: Optional[String]
    def actionDescription: Optional[String]
    def actionType: Optional[zio.aws.elasticbeanstalk.model.ActionType]
    def status: Optional[String]
    def getActionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionDescription", actionDescription)
    def getActionType
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
  ) extends zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly {
    override val actionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => value: String)
    override val actionDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.actionDescription())
      .map(value => value: String)
    override val actionType
        : Optional[zio.aws.elasticbeanstalk.model.ActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value => zio.aws.elasticbeanstalk.model.ActionType.wrap(value))
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
  ): zio.aws.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse.ReadOnly =
    new Wrapper(impl)
}
