package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait EnvironmentHealthStatus {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus
}
object EnvironmentHealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus
  ): zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.NO_DATA =>
      val r = NoData
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.UNKNOWN =>
      val r = Unknown
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.OK =>
      val r = Ok
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.INFO =>
      val r = Info
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.WARNING =>
      val r = Warning
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.DEGRADED =>
      val r = Degraded
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.SEVERE =>
      val r = Severe
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.SUSPENDED =>
      val r = Suspended
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NoData
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.NO_DATA
  }
  case object Unknown
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.UNKNOWN
  }
  case object Pending
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.PENDING
  }
  case object Ok
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.OK
  }
  case object Info
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.INFO
  }
  case object Warning
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.WARNING
  }
  case object Degraded
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.DEGRADED
  }
  case object Severe
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.SEVERE
  }
  case object Suspended
      extends zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus =
      software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus.SUSPENDED
  }
}
