package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait FailureType {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.FailureType
}
object FailureType {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.FailureType
  ): zio.aws.elasticbeanstalk.model.FailureType = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.UPDATE_CANCELLED =>
      val r = UpdateCancelled
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.CANCELLATION_FAILED =>
      val r = CancellationFailed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.ROLLBACK_FAILED =>
      val r = RollbackFailed
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.ROLLBACK_SUCCESSFUL =>
      val r = RollbackSuccessful
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.INTERNAL_FAILURE =>
      val r = InternalFailure
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.INVALID_ENVIRONMENT_STATE =>
      val r = InvalidEnvironmentState
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.PERMISSIONS_ERROR =>
      val r = PermissionsError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.UNKNOWN_TO_SDK_VERSION
  }
  case object UpdateCancelled
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.UPDATE_CANCELLED
  }
  case object CancellationFailed
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.CANCELLATION_FAILED
  }
  case object RollbackFailed
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.ROLLBACK_FAILED
  }
  case object RollbackSuccessful
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.ROLLBACK_SUCCESSFUL
  }
  case object InternalFailure
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.INTERNAL_FAILURE
  }
  case object InvalidEnvironmentState
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.INVALID_ENVIRONMENT_STATE
  }
  case object PermissionsError
      extends zio.aws.elasticbeanstalk.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.FailureType =
      software.amazon.awssdk.services.elasticbeanstalk.model.FailureType.PERMISSIONS_ERROR
  }
}
