package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait EventSeverity {
  def unwrap
      : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity
}
object EventSeverity {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity
  ): zio.aws.elasticbeanstalk.model.EventSeverity = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.TRACE =>
      val r = TRACE
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.DEBUG =>
      val r = DEBUG
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.WARN =>
      val r = WARN
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.FATAL =>
      val r = FATAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.EventSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object TRACE extends zio.aws.elasticbeanstalk.model.EventSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.TRACE
  }
  case object DEBUG extends zio.aws.elasticbeanstalk.model.EventSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.DEBUG
  }
  case object INFO extends zio.aws.elasticbeanstalk.model.EventSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.INFO
  }
  case object WARN extends zio.aws.elasticbeanstalk.model.EventSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.WARN
  }
  case object ERROR extends zio.aws.elasticbeanstalk.model.EventSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.ERROR
  }
  case object FATAL extends zio.aws.elasticbeanstalk.model.EventSeverity {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity =
      software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity.FATAL
  }
}
