package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  EnvironmentName,
  SolutionStackName,
  PlatformArn
}
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationOptionsRequest(
    applicationName: Optional[ApplicationName] = Optional.Absent,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    solutionStackName: Optional[SolutionStackName] = Optional.Absent,
    platformArn: Optional[PlatformArn] = Optional.Absent,
    options: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.OptionSpecification]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest = {
    import DescribeConfigurationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest =
      zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest(
        applicationName.map(value => value),
        templateName.map(value => value),
        environmentName.map(value => value),
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: Optional[ApplicationName]
    def templateName: Optional[ConfigurationTemplateName]
    def environmentName: Optional[EnvironmentName]
    def solutionStackName: Optional[SolutionStackName]
    def platformArn: Optional[PlatformArn]
    def options: Optional[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest.ReadOnly {
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val solutionStackName: Optional[SolutionStackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionStackName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
        )
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val options: Optional[
      List[zio.aws.elasticbeanstalk.model.OptionSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.OptionSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeConfigurationOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
