package zio.aws.elasticbeanstalk.model
import scala.jdk.CollectionConverters.*
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.elasticbeanstalk.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.elasticbeanstalk.model.ActionType
  ): zio.aws.elasticbeanstalk.model.ActionType = value match {
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.INSTANCE_REFRESH =>
      val r = InstanceRefresh
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.PLATFORM_UPDATE =>
      val r = PlatformUpdate
      r
    case software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.UNKNOWN =>
      val r = Unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticbeanstalk.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object InstanceRefresh
      extends zio.aws.elasticbeanstalk.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.INSTANCE_REFRESH
  }
  case object PlatformUpdate extends zio.aws.elasticbeanstalk.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.PLATFORM_UPDATE
  }
  case object Unknown extends zio.aws.elasticbeanstalk.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.elasticbeanstalk.model.ActionType =
      software.amazon.awssdk.services.elasticbeanstalk.model.ActionType.UNKNOWN
  }
}
