package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  Token,
  ApplicationName,
  EnvironmentName,
  MaxRecords,
  VersionLabel,
  PlatformArn,
  RequestId,
  EnvironmentId,
  TimeFilterStart,
  TimeFilterEnd
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEventsRequest(
    applicationName: Optional[ApplicationName] = Optional.Absent,
    versionLabel: Optional[VersionLabel] = Optional.Absent,
    templateName: Optional[ConfigurationTemplateName] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    platformArn: Optional[PlatformArn] = Optional.Absent,
    requestId: Optional[RequestId] = Optional.Absent,
    severity: Optional[zio.aws.elasticbeanstalk.model.EventSeverity] =
      Optional.Absent,
    startTime: Optional[TimeFilterStart] = Optional.Absent,
    endTime: Optional[TimeFilterEnd] = Optional.Absent,
    maxRecords: Optional[MaxRecords] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(
        startTime.map(value => TimeFilterStart.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => TimeFilterEnd.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEventsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.DescribeEventsRequest =
      zio.aws.elasticbeanstalk.model.DescribeEventsRequest(
        applicationName.map(value => value),
        versionLabel.map(value => value),
        templateName.map(value => value),
        environmentId.map(value => value),
        environmentName.map(value => value),
        platformArn.map(value => value),
        requestId.map(value => value),
        severity.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: Optional[ApplicationName]
    def versionLabel: Optional[VersionLabel]
    def templateName: Optional[ConfigurationTemplateName]
    def environmentId: Optional[EnvironmentId]
    def environmentName: Optional[EnvironmentName]
    def platformArn: Optional[PlatformArn]
    def requestId: Optional[RequestId]
    def severity: Optional[zio.aws.elasticbeanstalk.model.EventSeverity]
    def startTime: Optional[TimeFilterStart]
    def endTime: Optional[TimeFilterEnd]
    def maxRecords: Optional[MaxRecords]
    def nextToken: Optional[Token]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EventSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStartTime: ZIO[Any, AwsError, TimeFilterStart] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimeFilterEnd] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEventsRequest.ReadOnly {
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
        )
    override val versionLabel: Optional[VersionLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val templateName: Optional[ConfigurationTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(value)
        )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val requestId: Optional[RequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.RequestId(value))
    override val severity
        : Optional[zio.aws.elasticbeanstalk.model.EventSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.elasticbeanstalk.model.EventSeverity.wrap(value))
    override val startTime: Optional[TimeFilterStart] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.TimeFilterStart(value)
      )
    override val endTime: Optional[TimeFilterEnd] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.TimeFilterEnd(value)
      )
    override val maxRecords: Optional[MaxRecords] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.MaxRecords(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEventsRequest.ReadOnly =
    new Wrapper(impl)
}
