package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  RefreshedAt,
  Cause,
  EnvironmentName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeEnvironmentHealthResponse(
    environmentName: Optional[EnvironmentName] = Optional.Absent,
    healthStatus: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealth] =
      Optional.Absent,
    color: Optional[String] = Optional.Absent,
    causes: Optional[Iterable[Cause]] = Optional.Absent,
    applicationMetrics: Optional[
      zio.aws.elasticbeanstalk.model.ApplicationMetrics
    ] = Optional.Absent,
    instancesHealth: Optional[
      zio.aws.elasticbeanstalk.model.InstanceHealthSummary
    ] = Optional.Absent,
    refreshedAt: Optional[RefreshedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse = {
    import DescribeEnvironmentHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(healthStatus.map(value => value: java.lang.String))(
        _.healthStatus
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(color.map(value => value: java.lang.String))(_.color)
      .optionallyWith(
        causes.map(value =>
          value.map { item =>
            Cause.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.causes)
      .optionallyWith(applicationMetrics.map(value => value.buildAwsValue()))(
        _.applicationMetrics
      )
      .optionallyWith(instancesHealth.map(value => value.buildAwsValue()))(
        _.instancesHealth
      )
      .optionallyWith(
        refreshedAt.map(value => RefreshedAt.unwrap(value): Instant)
      )(_.refreshedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
      .wrap(buildAwsValue())
}
object DescribeEnvironmentHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse =
      zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse(
        environmentName.map(value => value),
        healthStatus.map(value => value),
        status.map(value => value),
        color.map(value => value),
        causes.map(value => value),
        applicationMetrics.map(value => value.asEditable),
        instancesHealth.map(value => value.asEditable),
        refreshedAt.map(value => value)
      )
    def environmentName: Optional[EnvironmentName]
    def healthStatus: Optional[String]
    def status: Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealth]
    def color: Optional[String]
    def causes: Optional[List[Cause]]
    def applicationMetrics
        : Optional[zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly]
    def instancesHealth: Optional[
      zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly
    ]
    def refreshedAt: Optional[RefreshedAt]
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getHealthStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EnvironmentHealth] =
      AwsError.unwrapOptionField("status", status)
    def getColor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("color", color)
    def getCauses: ZIO[Any, AwsError, List[Cause]] =
      AwsError.unwrapOptionField("causes", causes)
    def getApplicationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("applicationMetrics", applicationMetrics)
    def getInstancesHealth: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly
    ] = AwsError.unwrapOptionField("instancesHealth", instancesHealth)
    def getRefreshedAt: ZIO[Any, AwsError, RefreshedAt] =
      AwsError.unwrapOptionField("refreshedAt", refreshedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly {
    override val environmentName: Optional[EnvironmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
        )
    override val healthStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.healthStatus())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.elasticbeanstalk.model.EnvironmentHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentHealth.wrap(value)
        )
    override val color: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.color())
      .map(value => value: String)
    override val causes: Optional[List[Cause]] = zio.aws.core.internal
      .optionalFromNullable(impl.causes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.Cause(item)
        }.toList
      )
    override val applicationMetrics
        : Optional[zio.aws.elasticbeanstalk.model.ApplicationMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationMetrics())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ApplicationMetrics.wrap(value)
        )
    override val instancesHealth: Optional[
      zio.aws.elasticbeanstalk.model.InstanceHealthSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesHealth())
      .map(value =>
        zio.aws.elasticbeanstalk.model.InstanceHealthSummary.wrap(value)
      )
    override val refreshedAt: Optional[RefreshedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshedAt())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.RefreshedAt(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
  ): zio.aws.elasticbeanstalk.model.DescribeEnvironmentHealthResponse.ReadOnly =
    new Wrapper(impl)
}
