package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  SolutionStackName,
  PlatformArn,
  EnvironmentId,
  Description
}
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationTemplateRequest(
    applicationName: ApplicationName,
    templateName: ConfigurationTemplateName,
    solutionStackName: Optional[SolutionStackName] = Optional.Absent,
    platformArn: Optional[PlatformArn] = Optional.Absent,
    sourceConfiguration: Optional[
      zio.aws.elasticbeanstalk.model.SourceConfiguration
    ] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    optionSettings: Optional[
      Iterable[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticbeanstalk.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest = {
    import CreateConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .templateName(
        ConfigurationTemplateName.unwrap(templateName): java.lang.String
      )
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object CreateConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest =
      zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest(
        applicationName,
        templateName,
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        sourceConfiguration.map(value => value.asEditable),
        environmentId.map(value => value),
        description.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationName: ApplicationName
    def templateName: ConfigurationTemplateName
    def solutionStackName: Optional[SolutionStackName]
    def platformArn: Optional[PlatformArn]
    def sourceConfiguration
        : Optional[zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly]
    def environmentId: Optional[EnvironmentId]
    def description: Optional[Description]
    def optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getTemplateName: ZIO[Any, Nothing, ConfigurationTemplateName] =
      ZIO.succeed(templateName)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getOptionSettings: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("optionSettings", optionSettings)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
  ) extends zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val templateName: ConfigurationTemplateName =
      zio.aws.elasticbeanstalk.model.primitives
        .ConfigurationTemplateName(impl.templateName())
    override val solutionStackName: Optional[SolutionStackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionStackName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
        )
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val sourceConfiguration: Optional[
      zio.aws.elasticbeanstalk.model.SourceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceConfiguration())
      .map(value =>
        zio.aws.elasticbeanstalk.model.SourceConfiguration.wrap(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val optionSettings: Optional[
      List[zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.optionSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ConfigurationOptionSetting.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.elasticbeanstalk.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
  ): zio.aws.elasticbeanstalk.model.CreateConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
