package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{
  Token,
  PlatformBranchMaxRecords
}
import scala.jdk.CollectionConverters.*
final case class ListPlatformBranchesRequest(
    filters: Option[Iterable[zio.aws.elasticbeanstalk.model.SearchFilter]] =
      None,
    maxRecords: Option[PlatformBranchMaxRecords] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest = {
    import ListPlatformBranchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxRecords.map(value => PlatformBranchMaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest
      .wrap(buildAwsValue())
}
object ListPlatformBranchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest =
      zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Option[List[zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly]]
    def maxRecords: Option[PlatformBranchMaxRecords]
    def nextToken: Option[Token]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, PlatformBranchMaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
  ) extends zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.elasticbeanstalk.model.SearchFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.SearchFilter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[PlatformBranchMaxRecords] = scala
      .Option(impl.maxRecords())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .PlatformBranchMaxRecords(value)
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest
  ): zio.aws.elasticbeanstalk.model.ListPlatformBranchesRequest.ReadOnly =
    new Wrapper(impl)
}
