package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformName,
  PlatformCategory,
  OperatingSystemVersion,
  SolutionStackName,
  SupportedTier,
  PlatformArn,
  UpdateDate,
  Description,
  PlatformLifecycleState,
  SupportedAddon,
  PlatformBranchLifecycleState,
  Maintainer,
  PlatformVersion,
  PlatformOwner,
  OperatingSystemName,
  BranchName,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class PlatformDescription(
    platformArn: Option[PlatformArn] = None,
    platformOwner: Option[PlatformOwner] = None,
    platformName: Option[PlatformName] = None,
    platformVersion: Option[PlatformVersion] = None,
    solutionStackName: Option[SolutionStackName] = None,
    platformStatus: Option[zio.aws.elasticbeanstalk.model.PlatformStatus] =
      None,
    dateCreated: Option[CreationDate] = None,
    dateUpdated: Option[UpdateDate] = None,
    platformCategory: Option[PlatformCategory] = None,
    description: Option[Description] = None,
    maintainer: Option[Maintainer] = None,
    operatingSystemName: Option[OperatingSystemName] = None,
    operatingSystemVersion: Option[OperatingSystemVersion] = None,
    programmingLanguages: Option[
      Iterable[zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage]
    ] = None,
    frameworks: Option[
      Iterable[zio.aws.elasticbeanstalk.model.PlatformFramework]
    ] = None,
    customAmiList: Option[Iterable[zio.aws.elasticbeanstalk.model.CustomAmi]] =
      None,
    supportedTierList: Option[Iterable[SupportedTier]] = None,
    supportedAddonList: Option[Iterable[SupportedAddon]] = None,
    platformLifecycleState: Option[PlatformLifecycleState] = None,
    platformBranchName: Option[BranchName] = None,
    platformBranchLifecycleState: Option[PlatformBranchLifecycleState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription = {
    import PlatformDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
      .builder()
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        platformOwner.map(value =>
          PlatformOwner.unwrap(value): java.lang.String
        )
      )(_.platformOwner)
      .optionallyWith(
        platformName.map(value => PlatformName.unwrap(value): java.lang.String)
      )(_.platformName)
      .optionallyWith(
        platformVersion.map(value =>
          PlatformVersion.unwrap(value): java.lang.String
        )
      )(_.platformVersion)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(platformStatus.map(value => value.unwrap))(
        _.platformStatus
      )
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(
        platformCategory.map(value =>
          PlatformCategory.unwrap(value): java.lang.String
        )
      )(_.platformCategory)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        maintainer.map(value => Maintainer.unwrap(value): java.lang.String)
      )(_.maintainer)
      .optionallyWith(
        operatingSystemName.map(value =>
          OperatingSystemName.unwrap(value): java.lang.String
        )
      )(_.operatingSystemName)
      .optionallyWith(
        operatingSystemVersion.map(value =>
          OperatingSystemVersion.unwrap(value): java.lang.String
        )
      )(_.operatingSystemVersion)
      .optionallyWith(
        programmingLanguages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.programmingLanguages)
      .optionallyWith(
        frameworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameworks)
      .optionallyWith(
        customAmiList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customAmiList)
      .optionallyWith(
        supportedTierList.map(value =>
          value.map { item =>
            SupportedTier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedTierList)
      .optionallyWith(
        supportedAddonList.map(value =>
          value.map { item =>
            SupportedAddon.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedAddonList)
      .optionallyWith(
        platformLifecycleState.map(value =>
          PlatformLifecycleState.unwrap(value): java.lang.String
        )
      )(_.platformLifecycleState)
      .optionallyWith(
        platformBranchName.map(value =>
          BranchName.unwrap(value): java.lang.String
        )
      )(_.platformBranchName)
      .optionallyWith(
        platformBranchLifecycleState.map(value =>
          PlatformBranchLifecycleState.unwrap(value): java.lang.String
        )
      )(_.platformBranchLifecycleState)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformDescription.wrap(buildAwsValue())
}
object PlatformDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformDescription =
      zio.aws.elasticbeanstalk.model.PlatformDescription(
        platformArn.map(value => value),
        platformOwner.map(value => value),
        platformName.map(value => value),
        platformVersion.map(value => value),
        solutionStackName.map(value => value),
        platformStatus.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        platformCategory.map(value => value),
        description.map(value => value),
        maintainer.map(value => value),
        operatingSystemName.map(value => value),
        operatingSystemVersion.map(value => value),
        programmingLanguages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        frameworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customAmiList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedTierList.map(value => value),
        supportedAddonList.map(value => value),
        platformLifecycleState.map(value => value),
        platformBranchName.map(value => value),
        platformBranchLifecycleState.map(value => value)
      )
    def platformArn: Option[PlatformArn]
    def platformOwner: Option[PlatformOwner]
    def platformName: Option[PlatformName]
    def platformVersion: Option[PlatformVersion]
    def solutionStackName: Option[SolutionStackName]
    def platformStatus: Option[zio.aws.elasticbeanstalk.model.PlatformStatus]
    def dateCreated: Option[CreationDate]
    def dateUpdated: Option[UpdateDate]
    def platformCategory: Option[PlatformCategory]
    def description: Option[Description]
    def maintainer: Option[Maintainer]
    def operatingSystemName: Option[OperatingSystemName]
    def operatingSystemVersion: Option[OperatingSystemVersion]
    def programmingLanguages: Option[
      List[zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly]
    ]
    def frameworks: Option[
      List[zio.aws.elasticbeanstalk.model.PlatformFramework.ReadOnly]
    ]
    def customAmiList
        : Option[List[zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly]]
    def supportedTierList: Option[List[SupportedTier]]
    def supportedAddonList: Option[List[SupportedAddon]]
    def platformLifecycleState: Option[PlatformLifecycleState]
    def platformBranchName: Option[BranchName]
    def platformBranchLifecycleState: Option[PlatformBranchLifecycleState]
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getPlatformOwner: ZIO[Any, AwsError, PlatformOwner] =
      AwsError.unwrapOptionField("platformOwner", platformOwner)
    def getPlatformName: ZIO[Any, AwsError, PlatformName] =
      AwsError.unwrapOptionField("platformName", platformName)
    def getPlatformVersion: ZIO[Any, AwsError, PlatformVersion] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.PlatformStatus] =
      AwsError.unwrapOptionField("platformStatus", platformStatus)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getPlatformCategory: ZIO[Any, AwsError, PlatformCategory] =
      AwsError.unwrapOptionField("platformCategory", platformCategory)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMaintainer: ZIO[Any, AwsError, Maintainer] =
      AwsError.unwrapOptionField("maintainer", maintainer)
    def getOperatingSystemName: ZIO[Any, AwsError, OperatingSystemName] =
      AwsError.unwrapOptionField("operatingSystemName", operatingSystemName)
    def getOperatingSystemVersion: ZIO[Any, AwsError, OperatingSystemVersion] =
      AwsError.unwrapOptionField(
        "operatingSystemVersion",
        operatingSystemVersion
      )
    def getProgrammingLanguages: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly
    ]] =
      AwsError.unwrapOptionField("programmingLanguages", programmingLanguages)
    def getFrameworks: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.PlatformFramework.ReadOnly
    ]] = AwsError.unwrapOptionField("frameworks", frameworks)
    def getCustomAmiList: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly
    ]] = AwsError.unwrapOptionField("customAmiList", customAmiList)
    def getSupportedTierList: ZIO[Any, AwsError, List[SupportedTier]] =
      AwsError.unwrapOptionField("supportedTierList", supportedTierList)
    def getSupportedAddonList: ZIO[Any, AwsError, List[SupportedAddon]] =
      AwsError.unwrapOptionField("supportedAddonList", supportedAddonList)
    def getPlatformLifecycleState: ZIO[Any, AwsError, PlatformLifecycleState] =
      AwsError.unwrapOptionField(
        "platformLifecycleState",
        platformLifecycleState
      )
    def getPlatformBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("platformBranchName", platformBranchName)
    def getPlatformBranchLifecycleState
        : ZIO[Any, AwsError, PlatformBranchLifecycleState] =
      AwsError.unwrapOptionField(
        "platformBranchLifecycleState",
        platformBranchLifecycleState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
  ) extends zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly {
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val platformOwner: Option[PlatformOwner] = scala
      .Option(impl.platformOwner())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformOwner(value)
      )
    override val platformName: Option[PlatformName] = scala
      .Option(impl.platformName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformName(value)
      )
    override val platformVersion: Option[PlatformVersion] = scala
      .Option(impl.platformVersion())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformVersion(value)
      )
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformStatus
        : Option[zio.aws.elasticbeanstalk.model.PlatformStatus] = scala
      .Option(impl.platformStatus())
      .map(value => zio.aws.elasticbeanstalk.model.PlatformStatus.wrap(value))
    override val dateCreated: Option[CreationDate] = scala
      .Option(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Option[UpdateDate] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val platformCategory: Option[PlatformCategory] = scala
      .Option(impl.platformCategory())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformCategory(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val maintainer: Option[Maintainer] = scala
      .Option(impl.maintainer())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Maintainer(value))
    override val operatingSystemName: Option[OperatingSystemName] = scala
      .Option(impl.operatingSystemName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OperatingSystemName(value)
      )
    override val operatingSystemVersion: Option[OperatingSystemVersion] = scala
      .Option(impl.operatingSystemVersion())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OperatingSystemVersion(value)
      )
    override val programmingLanguages: Option[
      List[zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.ReadOnly]
    ] = scala
      .Option(impl.programmingLanguages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformProgrammingLanguage.wrap(item)
        }.toList
      )
    override val frameworks: Option[
      List[zio.aws.elasticbeanstalk.model.PlatformFramework.ReadOnly]
    ] = scala
      .Option(impl.frameworks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.PlatformFramework.wrap(item)
        }.toList
      )
    override val customAmiList
        : Option[List[zio.aws.elasticbeanstalk.model.CustomAmi.ReadOnly]] =
      scala
        .Option(impl.customAmiList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.CustomAmi.wrap(item)
          }.toList
        )
    override val supportedTierList: Option[List[SupportedTier]] = scala
      .Option(impl.supportedTierList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.SupportedTier(item)
        }.toList
      )
    override val supportedAddonList: Option[List[SupportedAddon]] = scala
      .Option(impl.supportedAddonList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.SupportedAddon(item)
        }.toList
      )
    override val platformLifecycleState: Option[PlatformLifecycleState] = scala
      .Option(impl.platformLifecycleState())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformLifecycleState(value)
      )
    override val platformBranchName: Option[BranchName] = scala
      .Option(impl.platformBranchName())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.BranchName(value))
    override val platformBranchLifecycleState
        : Option[PlatformBranchLifecycleState] = scala
      .Option(impl.platformBranchLifecycleState())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .PlatformBranchLifecycleState(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription
  ): zio.aws.elasticbeanstalk.model.PlatformDescription.ReadOnly = new Wrapper(
    impl
  )
}
