package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.LoadAverageValue
import scala.jdk.CollectionConverters.*
final case class SystemStatus(
    cpuUtilization: Option[zio.aws.elasticbeanstalk.model.CPUUtilization] =
      None,
    loadAverage: Option[Iterable[LoadAverageValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus = {
    import SystemStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus
      .builder()
      .optionallyWith(cpuUtilization.map(value => value.buildAwsValue()))(
        _.cpuUtilization
      )
      .optionallyWith(
        loadAverage.map(value =>
          value.map { item =>
            LoadAverageValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.loadAverage)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.SystemStatus.ReadOnly =
    zio.aws.elasticbeanstalk.model.SystemStatus.wrap(buildAwsValue())
}
object SystemStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.SystemStatus =
      zio.aws.elasticbeanstalk.model.SystemStatus(
        cpuUtilization.map(value => value.asEditable),
        loadAverage.map(value => value)
      )
    def cpuUtilization
        : Option[zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly]
    def loadAverage: Option[List[LoadAverageValue]]
    def getCpuUtilization: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly
    ] = AwsError.unwrapOptionField("cpuUtilization", cpuUtilization)
    def getLoadAverage: ZIO[Any, AwsError, List[LoadAverageValue]] =
      AwsError.unwrapOptionField("loadAverage", loadAverage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus
  ) extends zio.aws.elasticbeanstalk.model.SystemStatus.ReadOnly {
    override val cpuUtilization
        : Option[zio.aws.elasticbeanstalk.model.CPUUtilization.ReadOnly] = scala
      .Option(impl.cpuUtilization())
      .map(value => zio.aws.elasticbeanstalk.model.CPUUtilization.wrap(value))
    override val loadAverage: Option[List[LoadAverageValue]] = scala
      .Option(impl.loadAverage())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.LoadAverageValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus
  ): zio.aws.elasticbeanstalk.model.SystemStatus.ReadOnly = new Wrapper(impl)
}
