package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  DNSCname,
  ApplicationName,
  EnvironmentArn,
  OperationsRole,
  EnvironmentName,
  AbortableOperationInProgress,
  SolutionStackName,
  VersionLabel,
  PlatformArn,
  UpdateDate,
  EnvironmentId,
  Description,
  EndpointURL,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class TerminateEnvironmentResponse(
    environmentName: Option[EnvironmentName] = None,
    environmentId: Option[EnvironmentId] = None,
    applicationName: Option[ApplicationName] = None,
    versionLabel: Option[VersionLabel] = None,
    solutionStackName: Option[SolutionStackName] = None,
    platformArn: Option[PlatformArn] = None,
    templateName: Option[ConfigurationTemplateName] = None,
    description: Option[Description] = None,
    endpointURL: Option[EndpointURL] = None,
    cname: Option[DNSCname] = None,
    dateCreated: Option[CreationDate] = None,
    dateUpdated: Option[UpdateDate] = None,
    status: Option[zio.aws.elasticbeanstalk.model.EnvironmentStatus] = None,
    abortableOperationInProgress: Option[AbortableOperationInProgress] = None,
    health: Option[zio.aws.elasticbeanstalk.model.EnvironmentHealth] = None,
    healthStatus: Option[
      zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus
    ] = None,
    resources: Option[
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription
    ] = None,
    tier: Option[zio.aws.elasticbeanstalk.model.EnvironmentTier] = None,
    environmentLinks: Option[
      Iterable[zio.aws.elasticbeanstalk.model.EnvironmentLink]
    ] = None,
    environmentArn: Option[EnvironmentArn] = None,
    operationsRole: Option[OperationsRole] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse = {
    import TerminateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        solutionStackName.map(value =>
          SolutionStackName.unwrap(value): java.lang.String
        )
      )(_.solutionStackName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        endpointURL.map(value => EndpointURL.unwrap(value): java.lang.String)
      )(_.endpointURL)
      .optionallyWith(
        cname.map(value => DNSCname.unwrap(value): java.lang.String)
      )(_.cname)
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        abortableOperationInProgress.map(value =>
          AbortableOperationInProgress.unwrap(value): java.lang.Boolean
        )
      )(_.abortableOperationInProgress)
      .optionallyWith(health.map(value => value.unwrap))(_.health)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(tier.map(value => value.buildAwsValue()))(_.tier)
      .optionallyWith(
        environmentLinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentLinks)
      .optionallyWith(
        environmentArn.map(value =>
          EnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.environmentArn)
      .optionallyWith(
        operationsRole.map(value =>
          OperationsRole.unwrap(value): java.lang.String
        )
      )(_.operationsRole)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse
      .wrap(buildAwsValue())
}
object TerminateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse =
      zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse(
        environmentName.map(value => value),
        environmentId.map(value => value),
        applicationName.map(value => value),
        versionLabel.map(value => value),
        solutionStackName.map(value => value),
        platformArn.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        endpointURL.map(value => value),
        cname.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        status.map(value => value),
        abortableOperationInProgress.map(value => value),
        health.map(value => value),
        healthStatus.map(value => value),
        resources.map(value => value.asEditable),
        tier.map(value => value.asEditable),
        environmentLinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentArn.map(value => value),
        operationsRole.map(value => value)
      )
    def environmentName: Option[EnvironmentName]
    def environmentId: Option[EnvironmentId]
    def applicationName: Option[ApplicationName]
    def versionLabel: Option[VersionLabel]
    def solutionStackName: Option[SolutionStackName]
    def platformArn: Option[PlatformArn]
    def templateName: Option[ConfigurationTemplateName]
    def description: Option[Description]
    def endpointURL: Option[EndpointURL]
    def cname: Option[DNSCname]
    def dateCreated: Option[CreationDate]
    def dateUpdated: Option[UpdateDate]
    def status: Option[zio.aws.elasticbeanstalk.model.EnvironmentStatus]
    def abortableOperationInProgress: Option[AbortableOperationInProgress]
    def health: Option[zio.aws.elasticbeanstalk.model.EnvironmentHealth]
    def healthStatus
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus]
    def resources: Option[
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly
    ]
    def tier: Option[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly]
    def environmentLinks
        : Option[List[zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly]]
    def environmentArn: Option[EnvironmentArn]
    def operationsRole: Option[OperationsRole]
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getSolutionStackName: ZIO[Any, AwsError, SolutionStackName] =
      AwsError.unwrapOptionField("solutionStackName", solutionStackName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointURL: ZIO[Any, AwsError, EndpointURL] =
      AwsError.unwrapOptionField("endpointURL", endpointURL)
    def getCname: ZIO[Any, AwsError, DNSCname] =
      AwsError.unwrapOptionField("cname", cname)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAbortableOperationInProgress
        : ZIO[Any, AwsError, AbortableOperationInProgress] =
      AwsError.unwrapOptionField(
        "abortableOperationInProgress",
        abortableOperationInProgress
      )
    def getHealth
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EnvironmentHealth] =
      AwsError.unwrapOptionField("health", health)
    def getHealthStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus
    ] = AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getResources: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly
    ] = AwsError.unwrapOptionField("resources", resources)
    def getTier: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly
    ] = AwsError.unwrapOptionField("tier", tier)
    def getEnvironmentLinks: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentLinks", environmentLinks)
    def getEnvironmentArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("environmentArn", environmentArn)
    def getOperationsRole: ZIO[Any, AwsError, OperationsRole] =
      AwsError.unwrapOptionField("operationsRole", operationsRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
  ) extends zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly {
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val versionLabel: Option[VersionLabel] = scala
      .Option(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val solutionStackName: Option[SolutionStackName] = scala
      .Option(impl.solutionStackName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.SolutionStackName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val endpointURL: Option[EndpointURL] = scala
      .Option(impl.endpointURL())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EndpointURL(value)
      )
    override val cname: Option[DNSCname] = scala
      .Option(impl.cname())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.DNSCname(value))
    override val dateCreated: Option[CreationDate] = scala
      .Option(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Option[UpdateDate] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val status
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.elasticbeanstalk.model.EnvironmentStatus.wrap(value)
      )
    override val abortableOperationInProgress
        : Option[AbortableOperationInProgress] = scala
      .Option(impl.abortableOperationInProgress())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .AbortableOperationInProgress(value)
      )
    override val health
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentHealth] = scala
      .Option(impl.health())
      .map(value =>
        zio.aws.elasticbeanstalk.model.EnvironmentHealth.wrap(value)
      )
    override val healthStatus
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus] = scala
      .Option(impl.healthStatus())
      .map(value =>
        zio.aws.elasticbeanstalk.model.EnvironmentHealthStatus.wrap(value)
      )
    override val resources: Option[
      zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription.ReadOnly
    ] = scala
      .Option(impl.resources())
      .map(value =>
        zio.aws.elasticbeanstalk.model.EnvironmentResourcesDescription
          .wrap(value)
      )
    override val tier
        : Option[zio.aws.elasticbeanstalk.model.EnvironmentTier.ReadOnly] =
      scala
        .Option(impl.tier())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentTier.wrap(value)
        )
    override val environmentLinks: Option[
      List[zio.aws.elasticbeanstalk.model.EnvironmentLink.ReadOnly]
    ] = scala
      .Option(impl.environmentLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.EnvironmentLink.wrap(item)
        }.toList
      )
    override val environmentArn: Option[EnvironmentArn] = scala
      .Option(impl.environmentArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentArn(value)
      )
    override val operationsRole: Option[OperationsRole] = scala
      .Option(impl.operationsRole())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.OperationsRole(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse
  ): zio.aws.elasticbeanstalk.model.TerminateEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
