package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  ApplicationName,
  VersionLabel,
  UpdateDate,
  Description,
  ApplicationArn,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class ApplicationDescription(
    applicationArn: Option[ApplicationArn] = None,
    applicationName: Option[ApplicationName] = None,
    description: Option[Description] = None,
    dateCreated: Option[CreationDate] = None,
    dateUpdated: Option[UpdateDate] = None,
    versions: Option[Iterable[VersionLabel]] = None,
    configurationTemplates: Option[Iterable[ConfigurationTemplateName]] = None,
    resourceLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription = {
    import ApplicationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
      .builder()
      .optionallyWith(
        applicationArn.map(value =>
          ApplicationArn.unwrap(value): java.lang.String
        )
      )(_.applicationArn)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        dateCreated.map(value => CreationDate.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => UpdateDate.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            VersionLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        configurationTemplates.map(value =>
          value.map { item =>
            ConfigurationTemplateName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configurationTemplates)
      .optionallyWith(
        resourceLifecycleConfig.map(value => value.buildAwsValue())
      )(_.resourceLifecycleConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationDescription.wrap(buildAwsValue())
}
object ApplicationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ApplicationDescription =
      zio.aws.elasticbeanstalk.model.ApplicationDescription(
        applicationArn.map(value => value),
        applicationName.map(value => value),
        description.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        versions.map(value => value),
        configurationTemplates.map(value => value),
        resourceLifecycleConfig.map(value => value.asEditable)
      )
    def applicationArn: Option[ApplicationArn]
    def applicationName: Option[ApplicationName]
    def description: Option[Description]
    def dateCreated: Option[CreationDate]
    def dateUpdated: Option[UpdateDate]
    def versions: Option[List[VersionLabel]]
    def configurationTemplates: Option[List[ConfigurationTemplateName]]
    def resourceLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ]
    def getApplicationArn: ZIO[Any, AwsError, ApplicationArn] =
      AwsError.unwrapOptionField("applicationArn", applicationArn)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDateCreated: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, UpdateDate] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getVersions: ZIO[Any, AwsError, List[VersionLabel]] =
      AwsError.unwrapOptionField("versions", versions)
    def getConfigurationTemplates
        : ZIO[Any, AwsError, List[ConfigurationTemplateName]] = AwsError
      .unwrapOptionField("configurationTemplates", configurationTemplates)
    def getResourceLifecycleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourceLifecycleConfig",
      resourceLifecycleConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
  ) extends zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly {
    override val applicationArn: Option[ApplicationArn] = scala
      .Option(impl.applicationArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationArn(value)
      )
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Description(value)
      )
    override val dateCreated: Option[CreationDate] = scala
      .Option(impl.dateCreated())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.CreationDate(value)
      )
    override val dateUpdated: Option[UpdateDate] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.UpdateDate(value))
    override val versions: Option[List[VersionLabel]] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives.VersionLabel(item)
        }.toList
      )
    override val configurationTemplates
        : Option[List[ConfigurationTemplateName]] = scala
      .Option(impl.configurationTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.primitives
            .ConfigurationTemplateName(item)
        }.toList
      )
    override val resourceLifecycleConfig: Option[
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = scala
      .Option(impl.resourceLifecycleConfig())
      .map(value =>
        zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription
  ): zio.aws.elasticbeanstalk.model.ApplicationDescription.ReadOnly =
    new Wrapper(impl)
}
