package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApplicationVersionLifecycleConfig(
    maxCountRule: Option[zio.aws.elasticbeanstalk.model.MaxCountRule] = None,
    maxAgeRule: Option[zio.aws.elasticbeanstalk.model.MaxAgeRule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig = {
    import ApplicationVersionLifecycleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
      .builder()
      .optionallyWith(maxCountRule.map(value => value.buildAwsValue()))(
        _.maxCountRule
      )
      .optionallyWith(maxAgeRule.map(value => value.buildAwsValue()))(
        _.maxAgeRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly =
    zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
      .wrap(buildAwsValue())
}
object ApplicationVersionLifecycleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig =
      zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig(
        maxCountRule.map(value => value.asEditable),
        maxAgeRule.map(value => value.asEditable)
      )
    def maxCountRule
        : Option[zio.aws.elasticbeanstalk.model.MaxCountRule.ReadOnly]
    def maxAgeRule: Option[zio.aws.elasticbeanstalk.model.MaxAgeRule.ReadOnly]
    def getMaxCountRule: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.MaxCountRule.ReadOnly
    ] = AwsError.unwrapOptionField("maxCountRule", maxCountRule)
    def getMaxAgeRule: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.MaxAgeRule.ReadOnly
    ] = AwsError.unwrapOptionField("maxAgeRule", maxAgeRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
  ) extends zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly {
    override val maxCountRule
        : Option[zio.aws.elasticbeanstalk.model.MaxCountRule.ReadOnly] = scala
      .Option(impl.maxCountRule())
      .map(value => zio.aws.elasticbeanstalk.model.MaxCountRule.wrap(value))
    override val maxAgeRule
        : Option[zio.aws.elasticbeanstalk.model.MaxAgeRule.ReadOnly] = scala
      .Option(impl.maxAgeRule())
      .map(value => zio.aws.elasticbeanstalk.model.MaxAgeRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig
  ): zio.aws.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.ReadOnly =
    new Wrapper(impl)
}
