package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{BoxedInt, BoxedBoolean}
import scala.jdk.CollectionConverters.*
final case class MaxCountRule(
    enabled: BoxedBoolean,
    maxCount: Option[BoxedInt] = None,
    deleteSourceFromS3: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule = {
    import MaxCountRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(maxCount.map(value => value: Integer))(_.maxCount)
      .optionallyWith(
        deleteSourceFromS3.map(value => value: java.lang.Boolean)
      )(_.deleteSourceFromS3)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.MaxCountRule.ReadOnly =
    zio.aws.elasticbeanstalk.model.MaxCountRule.wrap(buildAwsValue())
}
object MaxCountRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.MaxCountRule =
      zio.aws.elasticbeanstalk.model.MaxCountRule(
        enabled,
        maxCount.map(value => value),
        deleteSourceFromS3.map(value => value)
      )
    def enabled: BoxedBoolean
    def maxCount: Option[BoxedInt]
    def deleteSourceFromS3: Option[BoxedBoolean]
    def getEnabled: ZIO[Any, Nothing, BoxedBoolean] = ZIO.succeed(enabled)
    def getMaxCount: ZIO[Any, AwsError, BoxedInt] =
      AwsError.unwrapOptionField("maxCount", maxCount)
    def getDeleteSourceFromS3: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("deleteSourceFromS3", deleteSourceFromS3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule
  ) extends zio.aws.elasticbeanstalk.model.MaxCountRule.ReadOnly {
    override val enabled: BoxedBoolean = impl.enabled(): BoxedBoolean
    override val maxCount: Option[BoxedInt] =
      scala.Option(impl.maxCount()).map(value => value: BoxedInt)
    override val deleteSourceFromS3: Option[BoxedBoolean] =
      scala.Option(impl.deleteSourceFromS3()).map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule
  ): zio.aws.elasticbeanstalk.model.MaxCountRule.ReadOnly = new Wrapper(impl)
}
