package zio.aws.elasticbeanstalk.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.{BoxedInt, BoxedBoolean}
import scala.jdk.CollectionConverters.*
final case class MaxAgeRule(
    enabled: BoxedBoolean,
    maxAgeInDays: Option[BoxedInt] = None,
    deleteSourceFromS3: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule = {
    import MaxAgeRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(maxAgeInDays.map(value => value: Integer))(_.maxAgeInDays)
      .optionallyWith(
        deleteSourceFromS3.map(value => value: java.lang.Boolean)
      )(_.deleteSourceFromS3)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.MaxAgeRule.ReadOnly =
    zio.aws.elasticbeanstalk.model.MaxAgeRule.wrap(buildAwsValue())
}
object MaxAgeRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.MaxAgeRule =
      zio.aws.elasticbeanstalk.model.MaxAgeRule(
        enabled,
        maxAgeInDays.map(value => value),
        deleteSourceFromS3.map(value => value)
      )
    def enabled: BoxedBoolean
    def maxAgeInDays: Option[BoxedInt]
    def deleteSourceFromS3: Option[BoxedBoolean]
    def getEnabled: ZIO[Any, Nothing, BoxedBoolean] = ZIO.succeed(enabled)
    def getMaxAgeInDays: ZIO[Any, AwsError, BoxedInt] =
      AwsError.unwrapOptionField("maxAgeInDays", maxAgeInDays)
    def getDeleteSourceFromS3: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("deleteSourceFromS3", deleteSourceFromS3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule
  ) extends zio.aws.elasticbeanstalk.model.MaxAgeRule.ReadOnly {
    override val enabled: BoxedBoolean = impl.enabled(): BoxedBoolean
    override val maxAgeInDays: Option[BoxedInt] =
      scala.Option(impl.maxAgeInDays()).map(value => value: BoxedInt)
    override val deleteSourceFromS3: Option[BoxedBoolean] =
      scala.Option(impl.deleteSourceFromS3()).map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule
  ): zio.aws.elasticbeanstalk.model.MaxAgeRule.ReadOnly = new Wrapper(impl)
}
