package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  ConfigurationTemplateName,
  Token,
  ApplicationName,
  EnvironmentName,
  MaxRecords,
  VersionLabel,
  PlatformArn,
  RequestId,
  EnvironmentId,
  TimeFilterStart,
  TimeFilterEnd
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEventsRequest(
    applicationName: Option[ApplicationName] = None,
    versionLabel: Option[VersionLabel] = None,
    templateName: Option[ConfigurationTemplateName] = None,
    environmentId: Option[EnvironmentId] = None,
    environmentName: Option[EnvironmentName] = None,
    platformArn: Option[PlatformArn] = None,
    requestId: Option[RequestId] = None,
    severity: Option[zio.aws.elasticbeanstalk.model.EventSeverity] = None,
    startTime: Option[TimeFilterStart] = None,
    endTime: Option[TimeFilterEnd] = None,
    maxRecords: Option[MaxRecords] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        versionLabel.map(value => VersionLabel.unwrap(value): java.lang.String)
      )(_.versionLabel)
      .optionallyWith(
        templateName.map(value =>
          ConfigurationTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        environmentName.map(value =>
          EnvironmentName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(
        startTime.map(value => TimeFilterStart.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => TimeFilterEnd.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeEventsRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.DescribeEventsRequest =
      zio.aws.elasticbeanstalk.model.DescribeEventsRequest(
        applicationName.map(value => value),
        versionLabel.map(value => value),
        templateName.map(value => value),
        environmentId.map(value => value),
        environmentName.map(value => value),
        platformArn.map(value => value),
        requestId.map(value => value),
        severity.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: Option[ApplicationName]
    def versionLabel: Option[VersionLabel]
    def templateName: Option[ConfigurationTemplateName]
    def environmentId: Option[EnvironmentId]
    def environmentName: Option[EnvironmentName]
    def platformArn: Option[PlatformArn]
    def requestId: Option[RequestId]
    def severity: Option[zio.aws.elasticbeanstalk.model.EventSeverity]
    def startTime: Option[TimeFilterStart]
    def endTime: Option[TimeFilterEnd]
    def maxRecords: Option[MaxRecords]
    def nextToken: Option[Token]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getVersionLabel: ZIO[Any, AwsError, VersionLabel] =
      AwsError.unwrapOptionField("versionLabel", versionLabel)
    def getTemplateName: ZIO[Any, AwsError, ConfigurationTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getEnvironmentName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.EventSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStartTime: ZIO[Any, AwsError, TimeFilterStart] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimeFilterEnd] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
  ) extends zio.aws.elasticbeanstalk.model.DescribeEventsRequest.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.ApplicationName(value)
      )
    override val versionLabel: Option[VersionLabel] = scala
      .Option(impl.versionLabel())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.VersionLabel(value)
      )
    override val templateName: Option[ConfigurationTemplateName] = scala
      .Option(impl.templateName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .ConfigurationTemplateName(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentId(value)
      )
    override val environmentName: Option[EnvironmentName] = scala
      .Option(impl.environmentName())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.EnvironmentName(value)
      )
    override val platformArn: Option[PlatformArn] = scala
      .Option(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val requestId: Option[RequestId] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.RequestId(value))
    override val severity
        : Option[zio.aws.elasticbeanstalk.model.EventSeverity] = scala
      .Option(impl.severity())
      .map(value => zio.aws.elasticbeanstalk.model.EventSeverity.wrap(value))
    override val startTime: Option[TimeFilterStart] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.TimeFilterStart(value)
      )
    override val endTime: Option[TimeFilterEnd] = scala
      .Option(impl.endTime())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.TimeFilterEnd(value)
      )
    override val maxRecords: Option[MaxRecords] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.MaxRecords(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest
  ): zio.aws.elasticbeanstalk.model.DescribeEventsRequest.ReadOnly =
    new Wrapper(impl)
}
