package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticbeanstalk.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationVersionsResponse(
    applicationVersions: Option[
      Iterable[zio.aws.elasticbeanstalk.model.ApplicationVersionDescription]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse = {
    import DescribeApplicationVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse
      .builder()
      .optionallyWith(
        applicationVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationVersions)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly =
    zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse =
      zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse(
        applicationVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationVersions: Option[List[
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
    ]]
    def nextToken: Option[Token]
    def getApplicationVersions: ZIO[Any, AwsError, List[
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("applicationVersions", applicationVersions)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse
  ) extends zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly {
    override val applicationVersions: Option[List[
      zio.aws.elasticbeanstalk.model.ApplicationVersionDescription.ReadOnly
    ]] = scala
      .Option(impl.applicationVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticbeanstalk.model.ApplicationVersionDescription
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse
  ): zio.aws.elasticbeanstalk.model.DescribeApplicationVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
